/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityConfigurationRegistry;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.service.ServiceRegistry;

public class EnversMetadataBuildingContextImpl
implements EnversMetadataBuildingContext {
    private static final String CONTRiBUTOR = "envers";
    private final Configuration configuration;
    private final InFlightMetadataCollector metadataCollector;
    private final MappingCollector mappingCollector;
    private final ObjectNameNormalizer objectNameNormalizer;
    private final AuditEntityNameRegister auditEntityNameRegistry;
    private final AuditEntityConfigurationRegistry auditEntityConfigurationRegistry;

    public EnversMetadataBuildingContextImpl(Configuration configuration, InFlightMetadataCollector metadataCollector, MappingCollector mappingCollector) {
        this.configuration = configuration;
        this.metadataCollector = metadataCollector;
        this.mappingCollector = mappingCollector;
        this.auditEntityNameRegistry = new AuditEntityNameRegister();
        this.auditEntityConfigurationRegistry = new AuditEntityConfigurationRegistry();
        this.objectNameNormalizer = new ObjectNameNormalizer(){

            protected MetadataBuildingContext getBuildingContext() {
                return EnversMetadataBuildingContextImpl.this;
            }
        };
    }

    public BootstrapContext getBootstrapContext() {
        return this.metadataCollector.getBootstrapContext();
    }

    public MetadataBuildingOptions getBuildingOptions() {
        return this.metadataCollector.getMetadataBuildingOptions();
    }

    public MappingDefaults getMappingDefaults() {
        return this.metadataCollector.getMetadataBuildingOptions().getMappingDefaults();
    }

    public InFlightMetadataCollector getMetadataCollector() {
        return this.metadataCollector;
    }

    public ObjectNameNormalizer getObjectNameNormalizer() {
        return this.objectNameNormalizer;
    }

    public TypeDefinitionRegistry getTypeDefinitionRegistry() {
        return this.metadataCollector.getTypeDefinitionRegistry();
    }

    public String getCurrentContributorName() {
        return CONTRiBUTOR;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MappingCollector getMappingCollector() {
        return this.mappingCollector;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.metadataCollector.getBootstrapContext().getServiceRegistry();
    }

    @Override
    public ReflectionManager getReflectionManager() {
        return this.metadataCollector.getBootstrapContext().getReflectionManager();
    }

    @Override
    public AuditEntityNameRegister getAuditEntityNameRegistry() {
        return this.auditEntityNameRegistry;
    }

    @Override
    public AuditEntityConfigurationRegistry getAuditEntityConfigurationRegistry() {
        return this.auditEntityConfigurationRegistry;
    }
}

