/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Locale;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.CompositeIdentifier;
import org.hibernate.envers.boot.model.IdentifierRelation;
import org.hibernate.envers.boot.model.ManyToOneAttribute;
import org.hibernate.envers.boot.registry.classloading.ClassLoaderAccessHelper;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.EmbeddedIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.MultipleIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.NestedEmbeddedIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;

public final class IdMetadataGenerator
extends AbstractMetadataGenerator {
    private final BasicMetadataGenerator basicMetadataGenerator;

    public IdMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, BasicMetadataGenerator basicMetadataGenerator) {
        super(metadataBuildingContext);
        this.basicMetadataGenerator = basicMetadataGenerator;
    }

    private Class<?> loadClass(Component component) {
        return ClassLoaderAccessHelper.loadClass(this.getMetadataBuildingContext(), component.getComponentClassName());
    }

    private static boolean isSameType(Property left, Property right) {
        return left.getType().getName().equals(right.getType().getName());
    }

    private boolean addIdProperty(AttributeContainer attributeContainer, boolean key, SimpleIdMapperBuilder mapper, Property mappedProperty, Property virtualProperty, boolean audited) {
        if ("_identifierMapper".equals(mappedProperty.getName())) {
            return false;
        }
        PropertyAuditingData propertyAuditingData = this.getIdPersistentPropertyAuditingData(mappedProperty);
        if (ManyToOneType.class.isInstance(mappedProperty.getType())) {
            boolean added = this.addManyToOne(attributeContainer, propertyAuditingData, mappedProperty.getValue(), mapper);
            if (added && mapper != null) {
                if (virtualProperty != null && !IdMetadataGenerator.isSameType(mappedProperty, virtualProperty)) {
                    propertyAuditingData.setPropertyType(mappedProperty.getType());
                    propertyAuditingData.setVirtualPropertyType(virtualProperty.getType());
                    mapper.add(propertyAuditingData.resolvePropertyData());
                } else {
                    propertyAuditingData.setPropertyType(mappedProperty.getType());
                    mapper.add(propertyAuditingData.resolvePropertyData());
                }
            }
            return added;
        }
        if (ComponentType.class.isInstance(mappedProperty.getType())) {
            NestedEmbeddedIdMapper nestedMapper;
            Component component = (Component)mappedProperty.getValue();
            if (mapper != null) {
                PropertyData propertyData = propertyAuditingData.resolvePropertyData();
                nestedMapper = new NestedEmbeddedIdMapper(propertyData, component);
                mapper.add(propertyData, nestedMapper);
            } else {
                nestedMapper = null;
            }
            return this.addIdProperties(attributeContainer, component, null, nestedMapper, key, audited);
        }
        return this.addBasic(attributeContainer, propertyAuditingData, mappedProperty.getValue(), mapper, key);
    }

    private boolean addIdProperties(AttributeContainer attributeContainer, Component component, Component virtualComponent, SimpleIdMapperBuilder mapper, boolean key, boolean audited) {
        for (Property property : component.getProperties()) {
            Property virtualProperty;
            if (this.addIdProperty(attributeContainer, key, mapper, property, virtualProperty = virtualComponent != null ? virtualComponent.getProperty(property.getName()) : null, audited)) continue;
            if (audited) {
                throw new EnversMappingException(String.format(Locale.ROOT, "Type not supported: %s", property.getType().getClass().getName()));
            }
            return false;
        }
        return true;
    }

    public void generateSecondPass(String entityName, PersistentClass persistentClass) {
        Component identifierMapper = persistentClass.getIdentifierMapper();
        Property identifierProperty = persistentClass.getIdentifierProperty();
        if (identifierMapper != null) {
            this.generateSecondPass(entityName, identifierMapper);
        } else if (identifierProperty != null && identifierProperty.isComposite()) {
            Component component = (Component)identifierProperty.getValue();
            this.generateSecondPass(entityName, component);
        }
    }

    private void generateSecondPass(String entityName, Component component) {
        for (Property property : component.getProperties()) {
            IdMapper relMapper;
            Value value = property.getValue();
            if (!(value instanceof ToOne)) continue;
            PropertyAuditingData propertyData = this.getIdPersistentPropertyAuditingData(property);
            String referencedEntityName = ((ToOne)value).getReferencedEntityName();
            String prefix = this.getMetadataBuildingContext().getConfiguration().getOriginalIdPropertyName() + "." + propertyData.getName();
            if (this.hasAuditedEntityConfiguration(referencedEntityName)) {
                relMapper = this.getAuditedEntityConfiguration(referencedEntityName).getIdMapper();
            } else if (this.hasNotAuditedEntityConfiguration(referencedEntityName)) {
                relMapper = this.getNotAuditedEntityConfiguration(referencedEntityName).getIdMapper();
            } else {
                throw new EnversMappingException("Unable to locate entity configuration for [" + referencedEntityName + "]");
            }
            IdMapper prefixedMapper = relMapper.prefixMappedProperties(prefix + ".");
            this.getAuditedEntityConfiguration(entityName).addToOneRelation(prefix, referencedEntityName, prefixedMapper, true, false);
        }
    }

    public IdMappingData addIdAndGetMappingData(PersistentClass persistentClass, boolean audited) {
        AbstractIdMapper mapper;
        Property idProp = persistentClass.getIdentifierProperty();
        Component idMapper = persistentClass.getIdentifierMapper();
        CompositeIdentifier identifier = new CompositeIdentifier(this.getMetadataBuildingContext());
        IdentifierRelation relation = new IdentifierRelation();
        if (idMapper == null && idProp == null) {
            return null;
        }
        if (idMapper != null) {
            Component virtualComponent = (Component)persistentClass.getIdentifier();
            if (!this.addIdProperties(relation, idMapper, virtualComponent, (SimpleIdMapperBuilder)((Object)(mapper = new MultipleIdMapper(virtualComponent))), false, audited)) {
                return null;
            }
            if (!this.addIdProperties(identifier, idMapper, virtualComponent, null, true, audited)) {
                return null;
            }
        } else if (idProp.isComposite()) {
            Component idComponent = (Component)idProp.getValue();
            if (!this.addIdProperties(relation, idComponent, null, (SimpleIdMapperBuilder)((Object)(mapper = new EmbeddedIdMapper(this.getIdPropertyData(idProp), idComponent))), false, audited)) {
                return null;
            }
            if (!this.addIdProperties(identifier, idComponent, null, null, true, audited)) {
                return null;
            }
        } else {
            mapper = new SingleIdMapper(persistentClass.getServiceRegistry());
            this.basicMetadataGenerator.addBasic(relation, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), (SimpleMapperBuilder)((Object)mapper), true, false);
            this.basicMetadataGenerator.addBasic(identifier, this.getIdPersistentPropertyAuditingData(idProp), idProp.getValue(), null, true, true);
        }
        this.addRevisionInfoRelationToIdentifier(identifier);
        return new IdMappingData(mapper, identifier, relation);
    }

    private PropertyData getIdPropertyData(Property property) {
        return new PropertyData(property.getName(), property.getName(), property.getPropertyAccessorName());
    }

    private PropertyAuditingData getIdPersistentPropertyAuditingData(Property property) {
        return new PropertyAuditingData(property.getName(), property.getPropertyAccessorName(), false);
    }

    public boolean addManyToOne(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper) {
        Type type = value.getType();
        ManyToOneAttribute attribute = new ManyToOneAttribute(propertyAuditingData.getName(), "", true, true, mapper == null, type.getName());
        attribute.setForeignKey("none");
        attribute.addColumnsFromValue(value);
        attributeContainer.addAttribute(attribute);
        return true;
    }

    public boolean addBasic(AttributeContainer attributeContainer, PropertyAuditingData propertyAuditingData, Value value, SimpleIdMapperBuilder mapper, boolean key) {
        return this.basicMetadataGenerator.addBasic(attributeContainer, propertyAuditingData, value, mapper, true, key);
    }
}

