/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class EntityInstantiator {
    private final EnversService enversService;
    private final AuditReaderImplementor versionsReader;

    public EntityInstantiator(EnversService enversService, AuditReaderImplementor versionsReader) {
        this.enversService = enversService;
        this.versionsReader = versionsReader;
    }

    public Object createInstanceFromVersionsEntity(String entityName, Map versionsEntity, Number revision) {
        if (versionsEntity == null) {
            return null;
        }
        String type = this.enversService.getEntitiesConfigurations().getEntityNameForVersionsEntityName((String)versionsEntity.get("$type$"));
        if (type != null) {
            entityName = type;
        }
        IdMapper idMapper = this.enversService.getEntitiesConfigurations().get(entityName).getIdMapper();
        Map originalId = (Map)versionsEntity.get(this.enversService.getConfig().getOriginalIdPropertyName());
        this.replaceNonAuditIdProxies(versionsEntity, revision);
        Object primaryKey = idMapper.mapToIdFromMap(originalId);
        if (this.versionsReader.getFirstLevelCache().contains(entityName, revision, primaryKey)) {
            return this.versionsReader.getFirstLevelCache().get(entityName, revision, primaryKey);
        }
        Object ret = this.versionsReader.getSessionImplementor().getFactory().getMappingMetamodel().getEntityDescriptor(entityName).getRepresentationStrategy().getInstantiator().instantiate(this.versionsReader.getSessionImplementor().getSessionFactory());
        this.versionsReader.getFirstLevelCache().put(entityName, revision, primaryKey, ret);
        this.enversService.getEntitiesConfigurations().get(entityName).getPropertyMapper().mapToEntityFromMap(this.enversService, ret, versionsEntity, primaryKey, this.versionsReader, revision);
        idMapper.mapToEntityFromMap(ret, originalId);
        this.versionsReader.getFirstLevelCache().putOnEntityNameCache(primaryKey, revision, ret, entityName);
        return ret;
    }

    private void replaceNonAuditIdProxies(Map versionsEntity, Number revision) {
        Map originalId = (Map)versionsEntity.get(this.enversService.getConfig().getOriginalIdPropertyName());
        for (Object key : originalId.keySet()) {
            Object value = originalId.get(key);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(value);
            if (lazyInitializer == null) continue;
            String entityName = lazyInitializer.getEntityName();
            Object entityId = lazyInitializer.getInternalIdentifier();
            if (!this.enversService.getEntitiesConfigurations().isVersioned(entityName)) continue;
            String entityClassName = this.enversService.getEntitiesConfigurations().get(entityName).getEntityClassName();
            Class entityClass = ReflectionTools.loadClass(entityClassName, this.enversService.getClassLoaderService());
            ToOneDelegateSessionImplementor delegate = new ToOneDelegateSessionImplementor(this.versionsReader, entityClass, entityId, revision, RevisionType.DEL.equals(versionsEntity.get(this.enversService.getConfig().getRevisionTypePropertyName())), this.enversService);
            originalId.put(key, this.versionsReader.getSessionImplementor().getFactory().getMappingMetamodel().getEntityDescriptor(entityName).createProxy(entityId, (SharedSessionContractImplementor)delegate));
        }
    }

    public void addInstancesFromVersionsEntities(String entityName, Collection addTo, List<Map> versionsEntities, Number revision) {
        for (Map versionsEntity : versionsEntities) {
            addTo.add(this.createInstanceFromVersionsEntity(entityName, versionsEntity, revision));
        }
    }

    public EnversService getEnversService() {
        return this.enversService;
    }

    public AuditReaderImplementor getAuditReaderImplementor() {
        return this.versionsReader;
    }
}

