/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl;

import com.sun.faces.application.ValidateComponentNesting;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.application.Application;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.SystemEventListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Stage {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ProjectStage projectStage;

    public ProjectStage getProjectStage(Application application) {
        if (this.projectStage == null) {
            String value = this.fetchProjectStageFromConfig();
            this.setProjectStageFromValue(value, ProjectStage.Production);
            if (this.projectStage == ProjectStage.Development) {
                application.subscribeToEvent(PostAddToViewEvent.class, (SystemEventListener)new ValidateComponentNesting());
            }
        }
        return this.projectStage;
    }

    private String fetchProjectStageFromConfig() {
        WebConfiguration webConfig = WebConfiguration.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        String value = webConfig.getEnvironmentEntry(WebConfiguration.WebEnvironmentEntry.ProjectStage);
        if (value != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ProjectStage configured via JNDI: {0}", value);
            }
        } else {
            value = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.JakartaFacesProjectStage);
            if (value != null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ProjectStage configured via servlet context init parameter: {0}", value);
            }
        }
        return value;
    }

    private void setProjectStageFromValue(String value, ProjectStage defaultStage) {
        block4: {
            if (value != null) {
                try {
                    this.projectStage = ProjectStage.valueOf((String)value);
                }
                catch (IllegalArgumentException iae) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block4;
                    LOGGER.log(Level.INFO, "Unable to discern ProjectStage for value {0}.", value);
                }
            }
        }
        if (this.projectStage == null) {
            this.projectStage = defaultStage;
        }
    }
}

