/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.Instruction;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.MessageUtils;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.List;

final class EndElementInstruction
implements Instruction {
    private static final String HEAD_ELEMENT = "head";
    private static final String BODY_ELEMENT = "body";
    private final String element;

    public EndElementInstruction(String element) {
        this.element = element;
    }

    @Override
    public void write(FacesContext context) throws IOException {
        if (HEAD_ELEMENT.equalsIgnoreCase(this.element)) {
            this.warnUnhandledResources(context, HEAD_ELEMENT);
        }
        if (BODY_ELEMENT.equalsIgnoreCase(this.element)) {
            this.warnUnhandledResources(context, BODY_ELEMENT);
            RenderKitUtils.renderUnhandledMessages(context);
        }
        context.getResponseWriter().endElement(this.element);
    }

    @Override
    public Instruction apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    private void warnUnhandledResources(FacesContext ctx, String target) {
        List headResources;
        UIViewRoot root = ctx.getViewRoot();
        if (root != null && (headResources = root.getComponentResources(ctx, target)) != null && !headResources.isEmpty()) {
            FacesMessage m = MessageUtils.getExceptionMessage("com.sun.faces.RESOURCE_TARGET_NOT_AVAILABLE", target);
            ctx.addMessage(null, m);
        }
    }
}

