/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jose.jwk;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.security.jose.jwk.JWK;
import org.wildfly.security.jose.jwk.JWKParser;
import org.wildfly.security.jose.jwk.JsonWebKeySet;

public class JsonWebKeySetUtil {
    public static Map<String, PublicKey> getKeysForUse(JsonWebKeySet keySet, JWK.Use requestedUse) {
        HashMap<String, PublicKey> result = new HashMap<String, PublicKey>();
        for (JWK jwk : keySet.getKeys()) {
            JWKParser parser = JWKParser.create(jwk);
            if (!jwk.getPublicKeyUse().equals(requestedUse.asString()) || !parser.isKeyTypeSupported(jwk.getKeyType())) continue;
            result.put(jwk.getKeyId(), parser.toPublicKey());
        }
        return result;
    }
}

