/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.logger.LauncherMessages;

class Jvm {
    private static final String JAVA_EXE;
    private static final Path JAVA_HOME;
    private static final boolean MODULAR_JVM;
    private static final boolean ENHANCED_SECURITY_MANAGER;
    private static final Jvm DEFAULT;
    private final Path path;
    private final boolean isModular;
    private final boolean enhancedSecurityManager;

    private Jvm(Path path, boolean isModular, boolean enhancedSecurityManager) {
        this.path = path;
        this.isModular = isModular;
        this.enhancedSecurityManager = enhancedSecurityManager;
    }

    static Jvm current() {
        return DEFAULT;
    }

    static Jvm of(String javaHome) {
        if (javaHome == null) {
            return DEFAULT;
        }
        return Jvm.of(Paths.get(javaHome, new String[0]));
    }

    static Jvm of(Path javaHome) {
        if (javaHome == null || javaHome.equals(JAVA_HOME)) {
            return DEFAULT;
        }
        Path path = Jvm.validateJavaHome(javaHome);
        return new Jvm(path, Jvm.isModularJavaHome(path), Jvm.hasEnhancedSecurityManager(javaHome));
    }

    public String getCommand() {
        return Jvm.resolveJavaCommand(this.path);
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isModular() {
        return this.isModular;
    }

    public boolean enhancedSecurityManagerAvailable() {
        return this.enhancedSecurityManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModularJavaHome(Path javaHome) {
        Path jmodsDir = javaHome.resolve("jmods");
        if (Files.isDirectory(jmodsDir, new LinkOption[0])) {
            return true;
        }
        Path releaseFile = javaHome.resolve("release");
        if (!Files.isReadable(releaseFile)) return Jvm.isModular(javaHome);
        if (!Files.isRegularFile(releaseFile, new LinkOption[0])) return Jvm.isModular(javaHome);
        try (BufferedReader reader = Files.newBufferedReader(releaseFile, StandardCharsets.UTF_8);){
            String line;
            do {
                if ((line = reader.readLine()) == null) return Jvm.isModular(javaHome);
            } while (!line.startsWith("JAVA_VERSION="));
            int index = line.indexOf(61);
            boolean bl = Jvm.isModularJavaVersion(line.substring(index + 1).replace("\"", ""));
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Jvm.isModular(javaHome);
    }

    private static boolean isModularJavaVersion(String version) {
        if (version != null) {
            try {
                String[] versionParts = version.split("\\.");
                if (versionParts.length == 1) {
                    return Integer.parseInt(versionParts[0]) >= 9;
                }
                if (versionParts.length > 1) {
                    if ("1".equals(versionParts[0])) {
                        return Integer.parseInt(versionParts[2]) >= 9;
                    }
                    return Integer.parseInt(versionParts[0]) >= 9;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean hasEnhancedSecurityManager(Path javaHome) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Jvm.resolveJavaCommand(javaHome));
        cmd.add("-Djava.security.manager=allow");
        cmd.add("-version");
        return Jvm.checkProcessStatus(cmd);
    }

    private static boolean isModular(Path javaHome) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Jvm.resolveJavaCommand(javaHome));
        cmd.add("--add-modules=java.se");
        cmd.add("-version");
        return Jvm.checkProcessStatus(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkProcessStatus(List<String> cmd) {
        boolean result;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        Process process = null;
        Path stdout = null;
        try {
            stdout = Files.createTempFile("stdout", ".txt", new FileAttribute[0]);
            process = builder.redirectErrorStream(true).redirectOutput(stdout.toFile()).start();
            result = process.waitFor(1L, TimeUnit.SECONDS) ? process.exitValue() == 0 : false;
        }
        catch (IOException | InterruptedException e) {
            result = false;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
            if (stdout != null) {
                try {
                    Files.deleteIfExists(stdout);
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static String resolveJavaCommand(Path javaHome) {
        String exe = javaHome == null ? "java" : javaHome.resolve("bin").resolve("java").toString();
        if (exe.contains(" ")) {
            return "\"" + exe + "\"";
        }
        return exe;
    }

    private static Path validateJavaHome(Path javaHome) {
        if (javaHome == null || Files.notExists(javaHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(javaHome);
        }
        if (!Files.isDirectory(javaHome, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(javaHome);
        }
        Path result = javaHome.toAbsolutePath().normalize();
        Path exe = result.resolve("bin").resolve(JAVA_EXE);
        if (Files.notExists(exe, new LinkOption[0])) {
            int count = exe.getNameCount();
            throw LauncherMessages.MESSAGES.invalidDirectory(exe.subpath(count - 2, count).toString(), javaHome);
        }
        return result;
    }

    static {
        Matcher matcher;
        String exe = "java";
        if (Environment.isWindows()) {
            exe = "java.exe";
        }
        JAVA_EXE = exe;
        String javaHome = System.getProperty("java.home");
        JAVA_HOME = Paths.get(javaHome, new String[0]);
        String javaSpecVersion = System.getProperty("java.specification.version");
        boolean modularJvm = true;
        boolean enhancedSecurityManager = false;
        if (javaSpecVersion != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(javaSpecVersion)).find()) {
            modularJvm = Integer.parseInt(matcher.group(1)) >= 9;
            enhancedSecurityManager = Integer.parseInt(matcher.group(1)) >= 12;
        }
        MODULAR_JVM = modularJvm;
        ENHANCED_SECURITY_MANAGER = enhancedSecurityManager;
        DEFAULT = new Jvm(JAVA_HOME, MODULAR_JVM, ENHANCED_SECURITY_MANAGER);
    }
}

