/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.wildfly.extension.undertow.AffinityCookieDefinition;
import org.wildfly.extension.undertow.AjpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpListenerResourceDefinition;
import org.wildfly.extension.undertow.HttpsListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.UndertowSubsystemModel;

public class UndertowExtensionTransformerRegistration
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "undertow";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        for (UndertowSubsystemModel model : EnumSet.complementOf(EnumSet.of(UndertowSubsystemModel.CURRENT))) {
            ModelVersion version = model.getVersion();
            ResourceTransformationDescriptionBuilder subsystem = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
            ResourceTransformationDescriptionBuilder server = subsystem.addChildResource(ServerDefinition.PATH_ELEMENT);
            for (PathElement listenerPath : Set.of(HttpListenerResourceDefinition.PATH_ELEMENT, HttpsListenerResourceDefinition.PATH_ELEMENT, AjpListenerResourceDefinition.PATH_ELEMENT)) {
                if (!UndertowSubsystemModel.VERSION_13_0_0.requiresTransformation(version)) continue;
                ((AttributeTransformationDescriptionBuilder)server.addChildResource(listenerPath).getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{ListenerResourceDefinition.WRITE_TIMEOUT, ListenerResourceDefinition.READ_TIMEOUT})).end();
            }
            ResourceTransformationDescriptionBuilder servletContainer = subsystem.addChildResource(ServletContainerDefinition.PATH_ELEMENT);
            if (UndertowSubsystemModel.VERSION_13_0_0.requiresTransformation(version)) {
                ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)servletContainer.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ServletContainerDefinition.ORPHAN_SESSION_ALLOWED})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ServletContainerDefinition.ORPHAN_SESSION_ALLOWED})).end();
                servletContainer.rejectChildResource(AffinityCookieDefinition.PATH_ELEMENT);
            }
            TransformationDescription.Tools.register((TransformationDescription)subsystem.build(), (SubsystemTransformerRegistration)registration, (ModelVersionRange)version);
        }
    }
}

