/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler;

import org.eclipse.tags.shaded.org.apache.bcel.generic.ConstantPoolGen;
import org.eclipse.tags.shaded.org.apache.bcel.generic.GOTO;
import org.eclipse.tags.shaded.org.apache.bcel.generic.InstructionList;
import org.eclipse.tags.shaded.org.apache.bcel.generic.PUSH;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.Expression;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.SymbolTable;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.util.Type;
import org.eclipse.tags.shaded.org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class BooleanExpr
extends Expression {
    private boolean _value;

    public BooleanExpr(boolean value) {
        this._value = value;
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this._type = Type.Boolean;
        return this._type;
    }

    public String toString() {
        return this._value ? "true()" : "false()";
    }

    public boolean getValue() {
        return this._value;
    }

    public boolean contextDependent() {
        return false;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(new PUSH(cpg, this._value));
    }

    public void translateDesynthesized(ClassGenerator classGen, MethodGenerator methodGen) {
        InstructionList il = methodGen.getInstructionList();
        if (this._value) {
            il.append(NOP);
        } else {
            this._falseList.add(il.append(new GOTO(null)));
        }
    }
}

