/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.routing;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ChildTargetService;
import org.wildfly.clustering.service.FunctionSupplierDependency;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.service.WebRequirement;
import org.wildfly.clustering.web.service.routing.LegacyRoutingProviderFactory;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.clustering.web.undertow.UndertowUnaryRequirement;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.session.DistributableServerRuntimeHandler;

public class UndertowDistributableServerRuntimeHandler
implements DistributableServerRuntimeHandler {
    private final LegacyRoutingProviderFactory legacyProviderFactory;

    public UndertowDistributableServerRuntimeHandler() {
        Iterator<LegacyRoutingProviderFactory> factories = ServiceLoader.load(LegacyRoutingProviderFactory.class, LegacyRoutingProviderFactory.class.getClassLoader()).iterator();
        if (!factories.hasNext()) {
            throw new ServiceConfigurationError(LegacyRoutingProviderFactory.class.getName());
        }
        this.legacyProviderFactory = factories.next();
    }

    public void execute(OperationContext context, final String serverName) {
        final SupplierDependency<RoutingProvider> provider = this.getRoutingProvider(context, serverName);
        if (provider != null) {
            ServiceTarget target = context.getServiceTarget();
            CapabilityServiceSupport support = context.getCapabilityServiceSupport();
            ServiceSupplierDependency server = new ServiceSupplierDependency(UndertowUnaryRequirement.SERVER.getServiceName(context, serverName));
            FunctionSupplierDependency route = new FunctionSupplierDependency((SupplierDependency)server, Server::getRoute);
            Consumer<ServiceTarget> installer = new Consumer<ServiceTarget>((SupplierDependency)route, support){
                final /* synthetic */ SupplierDependency val$route;
                final /* synthetic */ CapabilityServiceSupport val$support;
                {
                    this.val$route = supplierDependency2;
                    this.val$support = capabilityServiceSupport;
                }

                @Override
                public void accept(ServiceTarget target) {
                    for (CapabilityServiceConfigurator configurator : ((RoutingProvider)provider.get()).getServiceConfigurators(serverName, this.val$route)) {
                        configurator.configure(this.val$support).build(target).install();
                    }
                }
            };
            ServiceName name = ServiceName.JBOSS.append(new String[]{"clustering", "web", "undertow", "routing", serverName});
            provider.register(target.addService(name)).setInstance((Service)new ChildTargetService((Consumer)installer)).install();
        }
    }

    private SupplierDependency<RoutingProvider> getRoutingProvider(OperationContext context, String serverName) {
        if (context.hasOptionalCapability(WebRequirement.ROUTING_PROVIDER.getName(), UndertowUnaryRequirement.SERVER.resolve(serverName), null)) {
            return new ServiceSupplierDependency(WebRequirement.ROUTING_PROVIDER.getServiceName(context));
        }
        UndertowClusteringLogger.ROOT_LOGGER.legacyRoutingProviderInUse(serverName);
        return new SimpleSupplierDependency((Object)this.legacyProviderFactory.createRoutingProvider());
    }
}

