/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DelegatingSupplier;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseDependency;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

final class DeploymentPhaseContextImpl
extends SimpleAttachable
implements DeploymentPhaseContext {
    private final ServiceTarget serviceTarget;
    private final ServiceRegistry serviceRegistry;
    private final List<DeploymentUnitPhaseDependency> dependencies;
    private final DeploymentUnit deploymentUnitContext;
    private final Phase phase;

    DeploymentPhaseContextImpl(ServiceTarget serviceTarget, ServiceRegistry serviceRegistry, List<DeploymentUnitPhaseDependency> dependencies, DeploymentUnit deploymentUnitContext, Phase phase) {
        this.serviceTarget = serviceTarget;
        this.serviceRegistry = serviceRegistry;
        this.dependencies = dependencies;
        this.deploymentUnitContext = deploymentUnitContext;
        this.phase = phase;
    }

    @Override
    public ServiceName getPhaseServiceName() {
        return this.deploymentUnitContext.getServiceName().append(new String[]{this.phase.name()});
    }

    @Override
    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnitContext;
    }

    @Override
    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public <T> void addDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, false));
    }

    @Override
    public <T> void requires(ServiceName serviceName, DelegatingSupplier<T> supplier) {
        this.dependencies.add(new SupplierDeploymentPhaseDependency<T>(serviceName, supplier));
    }

    @Override
    public <T> void addDeploymentDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, true));
    }

    private static final class SupplierDeploymentPhaseDependency<T>
    implements DeploymentUnitPhaseDependency {
        private final ServiceName name;
        private final DelegatingSupplier<T> supplier;

        private SupplierDeploymentPhaseDependency(ServiceName name, DelegatingSupplier<T> supplier) {
            this.name = name;
            this.supplier = supplier;
        }

        @Override
        public void register(ServiceBuilder<?> builder) {
            this.supplier.set(builder.requires(this.name));
        }
    }
}

