/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.facet.DrillSidewaysScorer;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DrillSidewaysQuery
extends Query {
    final Query baseQuery;
    final FacetsCollectorManager drillDownCollectorManager;
    final FacetsCollectorManager[] drillSidewaysCollectorManagers;
    final List<FacetsCollector> managedDrillDownCollectors;
    final List<FacetsCollector[]> managedDrillSidewaysCollectors;
    final Query[] drillDownQueries;
    final boolean scoreSubDocsAtOnce;

    DrillSidewaysQuery(Query baseQuery, FacetsCollectorManager drillDownCollectorManager, FacetsCollectorManager[] drillSidewaysCollectorManagers, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this(baseQuery, drillDownCollectorManager, drillSidewaysCollectorManagers, Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), drillDownQueries, scoreSubDocsAtOnce);
    }

    private DrillSidewaysQuery(Query baseQuery, FacetsCollectorManager drillDownCollectorManager, FacetsCollectorManager[] drillSidewaysCollectorManagers, List<FacetsCollector> managedDrillDownCollectors, List<FacetsCollector[]> managedDrillSidewaysCollectors, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this.baseQuery = Objects.requireNonNull(baseQuery);
        this.drillDownCollectorManager = drillDownCollectorManager;
        this.drillSidewaysCollectorManagers = drillSidewaysCollectorManagers;
        this.managedDrillDownCollectors = managedDrillDownCollectors;
        this.managedDrillSidewaysCollectors = managedDrillSidewaysCollectors;
        this.drillDownQueries = drillDownQueries;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
    }

    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery;
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(reader)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return super.rewrite(reader);
        }
        return new DrillSidewaysQuery(newQuery, this.drillDownCollectorManager, this.drillSidewaysCollectorManagers, this.managedDrillDownCollectors, this.managedDrillSidewaysCollectors, this.drillDownQueries, this.scoreSubDocsAtOnce);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher, scoreMode, boost);
        final Weight[] drillDowns = new Weight[this.drillDownQueries.length];
        for (int dim = 0; dim < this.drillDownQueries.length; ++dim) {
            drillDowns[dim] = searcher.createWeight(searcher.rewrite(this.drillDownQueries[dim]), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                FacetsCollector drillDownCollector;
                Scorer baseScorer = baseWeight.scorer(context);
                int drillDownCount = drillDowns.length;
                FacetsCollector[] sidewaysCollectors = new FacetsCollector[drillDownCount];
                DrillSidewaysQuery.this.managedDrillSidewaysCollectors.add(sidewaysCollectors);
                DrillSidewaysScorer.DocsAndCost[] dims = new DrillSidewaysScorer.DocsAndCost[drillDownCount];
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    FacetsCollector sidewaysCollector;
                    Scorer scorer = drillDowns[dim].scorer(context);
                    if (scorer == null) {
                        ++nullCount;
                        scorer = new ConstantScoreScorer(drillDowns[dim], 0.0f, scoreMode, DocIdSetIterator.empty());
                    }
                    sidewaysCollectors[dim] = sidewaysCollector = DrillSidewaysQuery.this.drillSidewaysCollectorManagers[dim].newCollector();
                    dims[dim] = new DrillSidewaysScorer.DocsAndCost(scorer, sidewaysCollector);
                }
                if (nullCount > 1) {
                    return null;
                }
                Arrays.sort(dims, new Comparator<DrillSidewaysScorer.DocsAndCost>(){

                    @Override
                    public int compare(DrillSidewaysScorer.DocsAndCost o1, DrillSidewaysScorer.DocsAndCost o2) {
                        return Long.compare(o1.approximation.cost(), o2.approximation.cost());
                    }
                });
                if (baseScorer == null) {
                    return null;
                }
                if (DrillSidewaysQuery.this.drillDownCollectorManager != null) {
                    drillDownCollector = DrillSidewaysQuery.this.drillDownCollectorManager.newCollector();
                    DrillSidewaysQuery.this.managedDrillDownCollectors.add(drillDownCollector);
                } else {
                    drillDownCollector = null;
                }
                return new DrillSidewaysScorer(context, baseScorer, drillDownCollector, dims, DrillSidewaysQuery.this.scoreSubDocsAtOnce);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.baseQuery);
        result = 31 * result + Objects.hashCode(this.drillDownCollectorManager);
        result = 31 * result + Arrays.hashCode(this.drillDownQueries);
        result = 31 * result + Arrays.hashCode(this.drillSidewaysCollectorManagers);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DrillSidewaysQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DrillSidewaysQuery other) {
        return Objects.equals(this.baseQuery, other.baseQuery) && Objects.equals(this.drillDownCollectorManager, other.drillDownCollectorManager) && Arrays.equals(this.drillDownQueries, other.drillDownQueries) && Arrays.equals(this.drillSidewaysCollectorManagers, other.drillSidewaysCollectorManagers);
    }
}

