/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.net.InetAddress;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;

public interface ConfigurationChangesCollector {
    public static final ConfigurationChangesCollectorImpl INSTANCE = new ConfigurationChangesCollectorImpl(0);

    public void addConfigurationChanges(ConfigurationChange var1);

    public List<ModelNode> getChanges();

    public void setMaxHistory(int var1);

    public boolean trackAllowed();

    public void deactivate();

    public static final class ConfigurationChange {
        private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendInstant(3).toFormatter(Locale.ENGLISH);
        private final OperationContext.ResultAction resultAction;
        private final String userId;
        private final String domainUuid;
        private final AccessMechanism accessMecanism;
        private final InetAddress inetAddress;
        private final List<ModelNode> operations;
        private Instant date;

        public ConfigurationChange(OperationContext.ResultAction resultAction, String userId, String domainUuid, AccessMechanism accessMecanism, InetAddress inetAddress, List<ModelNode> operations) {
            this.resultAction = resultAction;
            this.userId = userId;
            this.domainUuid = domainUuid;
            this.accessMecanism = accessMecanism;
            this.inetAddress = inetAddress;
            this.operations = operations;
            this.date = Instant.EPOCH;
        }

        private String getDate() {
            return DATE_FORMAT.format(this.date);
        }

        public Instant getOperationInstant() {
            return this.date;
        }

        public void setOperationInstant() {
            this.date = Instant.now();
        }

        public ModelNode asModel() {
            ModelNode entry = new ModelNode().setEmptyObject();
            entry.get("operation-date").set(this.getDate());
            if (this.domainUuid != null) {
                entry.get("domain-uuid").set(this.domainUuid);
            }
            if (this.accessMecanism != null) {
                entry.get("access-mechanism").set(this.accessMecanism.toString());
            }
            if (this.inetAddress != null) {
                entry.get("remote-address").set(this.inetAddress.toString());
            }
            entry.get("outcome").set(this.resultAction == OperationContext.ResultAction.KEEP ? "success" : "failed");
            if (this.operations != null && !this.operations.isEmpty()) {
                ModelNode changes = entry.get("operations").setEmptyList();
                for (ModelNode op : this.operations) {
                    changes.add(op);
                }
            }
            return entry;
        }
    }

    public static class ConfigurationChangesCollectorImpl
    implements ConfigurationChangesCollector {
        private final Deque<ConfigurationChange> history = new ArrayDeque<ConfigurationChange>();
        private int maxHistory;

        private ConfigurationChangesCollectorImpl(int maxHistory) {
            this.maxHistory = maxHistory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConfigurationChanges(ConfigurationChange change) {
            Deque<ConfigurationChange> deque = this.history;
            synchronized (deque) {
                if (this.history.size() == this.maxHistory) {
                    this.history.removeLast();
                }
                change.setOperationInstant();
                this.history.addFirst(change);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMaxHistory(int maxHistory) {
            Deque<ConfigurationChange> deque = this.history;
            synchronized (deque) {
                this.maxHistory = maxHistory;
                while (maxHistory < this.history.size()) {
                    this.history.removeLast();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ModelNode> getChanges() {
            ArrayDeque<ConfigurationChange> changes;
            Deque<ConfigurationChange> deque = this.history;
            synchronized (deque) {
                changes = new ArrayDeque<ConfigurationChange>(this.history);
            }
            ModelNode result = new ModelNode().setEmptyList();
            for (ConfigurationChange change : changes) {
                result.add(change.asModel());
            }
            return result.asList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean trackAllowed() {
            Deque<ConfigurationChange> deque = this.history;
            synchronized (deque) {
                return this.maxHistory > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deactivate() {
            Deque<ConfigurationChange> deque = this.history;
            synchronized (deque) {
                this.maxHistory = 0;
                this.history.clear();
            }
        }
    }
}

