/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class TransformersLogger {
    private TransformationTarget target;
    private ControllerLogger logger;
    private List<LogEntry> messageQueue = Collections.synchronizedList(new LinkedList());
    private static final ConcurrentHashMap<String, TransformersLogger> loggers = new ConcurrentHashMap();

    private TransformersLogger(TransformationTarget target) {
        this.target = target;
        this.logger = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)("org.jboss.as.controller.transformer." + target.getHostName()));
    }

    public static TransformersLogger getLogger(TransformationTarget target) {
        String hostName = target.getHostName() == null ? "<unknown>" : target.getHostName();
        TransformersLogger result = loggers.get(hostName);
        if (result == null) {
            result = new TransformersLogger(target);
            TransformersLogger existing = loggers.putIfAbsent(hostName, result);
            result = existing == null ? result : existing;
        }
        return result;
    }

    private static String findSubsystemName(PathAddress pathAddress) {
        for (PathElement element : pathAddress) {
            if (!element.getKey().equals("subsystem")) continue;
            return element.getValue();
        }
        return null;
    }

    public void logAttributeWarning(PathAddress address, String attribute) {
        this.logAttributeWarning(address, null, null, attribute);
    }

    public void logAttributeWarning(PathAddress address, Set<String> attributes) {
        this.logAttributeWarning(address, null, null, attributes);
    }

    public void logAttributeWarning(PathAddress address, String message, String attribute) {
        this.logAttributeWarning(address, null, message, attribute);
    }

    public void logAttributeWarning(PathAddress address, String message, Set<String> attributes) {
        this.messageQueue.add(new AttributeLogEntry(address, null, message, attributes));
    }

    public void logAttributeWarning(PathAddress address, ModelNode operation, String message, String attribute) {
        this.messageQueue.add(new AttributeLogEntry(address, operation, message, attribute));
    }

    public void logAttributeWarning(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
        this.messageQueue.add(new AttributeLogEntry(address, operation, message, attributes));
    }

    public String getAttributeWarning(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
        return new AttributeLogEntry(address, operation, message, attributes).getMessage();
    }

    private String getAttributeWarning(PathAddress address, ModelNode operation, String message, String ... attributes) {
        return new AttributeLogEntry(address, operation, message, attributes).getMessage();
    }

    public String getAttributeWarning(PathAddress address, ModelNode operation, String ... attributes) {
        return this.getAttributeWarning(address, operation, (String)null, attributes);
    }

    public String getAttributeWarning(PathAddress address, ModelNode operation, Set<String> attributes) {
        return new AttributeLogEntry(address, operation, null, attributes).getMessage();
    }

    public String getRejectedResourceWarning(PathAddress address, ModelNode operation) {
        return new RejectResourceLogEntry(address, operation).getMessage();
    }

    public void logRejectedResourceWarning(PathAddress address, ModelNode operation) {
        this.messageQueue.add(new RejectResourceLogEntry(address, null));
    }

    public void logDiscardedResourceWarning(final PathAddress address, final String host) {
        this.messageQueue.add(new LogEntry(){

            @Override
            public String getMessage() {
                return ControllerLogger.ROOT_LOGGER.discardedResourceTransformation(address, host);
            }
        });
    }

    public void logWarning(final String message) {
        this.messageQueue.add(new LogEntry(){

            @Override
            public String getMessage() {
                return message;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushLogQueue() {
        LinkedHashSet<String> problems = new LinkedHashSet<String>();
        List<LogEntry> list = this.messageQueue;
        synchronized (list) {
            Iterator<LogEntry> i = this.messageQueue.iterator();
            while (i.hasNext()) {
                problems.add("\t\t" + i.next().getMessage() + "\n");
                i.remove();
            }
        }
        if (!problems.isEmpty()) {
            this.logger.transformationWarnings(this.target.getHostName(), problems);
        }
    }

    private class RejectResourceLogEntry
    implements LogEntry {
        private final PathAddress address;
        private final ModelNode operation;

        private RejectResourceLogEntry(PathAddress address, ModelNode operation) {
            this.address = address;
            this.operation = operation;
        }

        @Override
        public String getMessage() {
            if (this.operation != null) {
                return ControllerLogger.ROOT_LOGGER.rejectResourceOperationTransformation(this.address, this.operation);
            }
            return ControllerLogger.ROOT_LOGGER.rejectedResourceResourceTransformation(this.address);
        }
    }

    private class AttributeLogEntry
    implements LogEntry {
        private final PathAddress address;
        private final ModelNode operation;
        private final String message;
        private final Set<String> attributes;

        private AttributeLogEntry(PathAddress address, ModelNode operation, String message, String ... attributes) {
            this(address, operation, message, new TreeSet<String>(Arrays.asList(attributes)));
        }

        private AttributeLogEntry(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
            assert (message != null || attributes != null && !attributes.isEmpty()) : "a message must be provided or a list of attributes or both";
            this.address = address;
            this.operation = operation;
            this.message = message;
            this.attributes = attributes;
        }

        @Override
        public String getMessage() {
            String attributeSet;
            ModelVersion coreVersion = TransformersLogger.this.target.getVersion();
            String subsystemName = TransformersLogger.findSubsystemName(this.address);
            ModelVersion usedVersion = subsystemName == null ? coreVersion : TransformersLogger.this.target.getSubsystemVersion(subsystemName);
            String msg = this.message == null ? ControllerLogger.ROOT_LOGGER.attributesAreNotUnderstoodAndMustBeIgnored() : this.message;
            String string = attributeSet = this.attributes != null && !this.attributes.isEmpty() ? ControllerLogger.ROOT_LOGGER.attributeNames(this.attributes) : "";
            if (this.operation == null) {
                if (subsystemName != null) {
                    return ControllerLogger.ROOT_LOGGER.transformerLoggerSubsystemModelResourceTransformerAttributes(this.address, subsystemName, usedVersion, attributeSet, msg);
                }
                return ControllerLogger.ROOT_LOGGER.transformerLoggerCoreModelResourceTransformerAttributes(this.address, usedVersion, attributeSet, msg);
            }
            if (subsystemName != null) {
                return ControllerLogger.ROOT_LOGGER.transformerLoggerSubsystemModelOperationTransformerAttributes(this.operation, this.address, subsystemName, usedVersion, attributeSet, msg);
            }
            return ControllerLogger.ROOT_LOGGER.transformerLoggerCoreModelOperationTransformerAttributes(this.operation, this.address, usedVersion, attributeSet, msg);
        }
    }

    private static interface LogEntry {
        public String getMessage();
    }
}

