/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.logging;

import jakarta.jms.IllegalStateRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class MessagingLogger_$logger
extends DelegatingBasicLogger
implements MessagingLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MessagingLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void aioInfo() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.aioInfo$str(), new Object[0]);
    }

    protected String aioInfo$str() {
        return "WFLYMSGAMQ0001: AIO wasn't located on this platform, it will fall back to using pure Java NIO.";
    }

    @Override
    public final void boundJndiName(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.boundJndiName$str(), (Object)jndiName);
    }

    protected String boundJndiName$str() {
        return "WFLYMSGAMQ0002: Bound messaging object to jndi name %s";
    }

    @Override
    public final void errorStoppingJmsServer(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorStoppingJmsServer$str(), new Object[0]);
    }

    protected String errorStoppingJmsServer$str() {
        return "WFLYMSGAMQ0003: Exception while stopping Jakarta Messaging server";
    }

    @Override
    public final void failedToDestroy(Throwable cause, String description, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToDestroy$str(), (Object)description, (Object)name);
    }

    protected String failedToDestroy$str() {
        return "WFLYMSGAMQ0004: Failed to destroy %s: %s";
    }

    @Override
    public final void failedToDestroy(String description, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToDestroy$str(), (Object)description, (Object)name);
    }

    @Override
    public final void revertOperationFailed(Throwable cause, String className, String operation, PathAddress address) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.revertOperationFailed$str(), (Object)className, (Object)operation, (Object)address);
    }

    protected String revertOperationFailed$str() {
        return "WFLYMSGAMQ0005: %s caught exception attempting to revert operation %s at address %s";
    }

    @Override
    public final void unboundJndiName(String jndiName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.unboundJndiName$str(), (Object)jndiName);
    }

    protected String unboundJndiName$str() {
        return "WFLYMSGAMQ0006: Unbound messaging object to jndi name %s";
    }

    @Override
    public final void couldNotCloseFile(String file, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.couldNotCloseFile$str(), (Object)file);
    }

    protected String couldNotCloseFile$str() {
        return "WFLYMSGAMQ0007: Could not close file %s";
    }

    @Override
    public final void failedToUnbindJndiName(String jndiName, long timeout, String timeUnit) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToUnbindJndiName$str(), (Object)jndiName, (Object)timeout, (Object)timeUnit);
    }

    protected String failedToUnbindJndiName$str() {
        return "WFLYMSGAMQ0008: Failed to unbind messaging object bound to jndi name %s in %d %s";
    }

    @Override
    public final void startedService(String type, String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startedService$str(), (Object)type, (Object)name);
    }

    protected String startedService$str() {
        return "WFLYMSGAMQ0011: Started %s %s";
    }

    @Override
    public final void stoppedService(String type, String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.stoppedService$str(), (Object)type, (Object)name);
    }

    protected String stoppedService$str() {
        return "WFLYMSGAMQ0012: Stopped %s %s";
    }

    @Override
    public final void unknownPooledConnectionFactoryAttribute(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownPooledConnectionFactoryAttribute$str(), (Object)name);
    }

    protected String unknownPooledConnectionFactoryAttribute$str() {
        return "WFLYMSGAMQ0015: Ignoring %s property that is not a known property for pooled connection factory.";
    }

    @Override
    public final void registeredHTTPUpgradeHandler(String name, String acceptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.registeredHTTPUpgradeHandler$str(), (Object)name, (Object)acceptor);
    }

    protected String registeredHTTPUpgradeHandler$str() {
        return "WFLYMSGAMQ0016: Registered HTTP upgrade for %s protocol handled by %s acceptor";
    }

    @Override
    public final void connectorForPooledConnectionFactory(String name, String connectorName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.connectorForPooledConnectionFactory$str(), (Object)name, (Object)connectorName);
    }

    protected String connectorForPooledConnectionFactory$str() {
        return "WFLYMSGAMQ0018: No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.";
    }

    protected String cannotBindJndiName$str() {
        return "WFLYMSGAMQ0022: Cannot bind a null or empty string as jndi name";
    }

    @Override
    public final IllegalArgumentException cannotBindJndiName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotBindJndiName$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotUnbindJndiName$str() {
        return "WFLYMSGAMQ0025: Cannot unbind a null or empty string as jndi name";
    }

    @Override
    public final IllegalArgumentException cannotUnbindJndiName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotUnbindJndiName$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String childResourceAlreadyExists$str() {
        return "WFLYMSGAMQ0026: A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s";
    }

    @Override
    public final String childResourceAlreadyExists(String type) {
        return String.format(this.getLoggingLocale(), this.childResourceAlreadyExists$str(), type);
    }

    protected String connectorNotDefined$str() {
        return "WFLYMSGAMQ0027: Connector %s not defined";
    }

    @Override
    public final IllegalStateException connectorNotDefined(String connectorName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.connectorNotDefined$str(), connectorName));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToCreate$str() {
        return "WFLYMSGAMQ0028: Failed to create %s";
    }

    @Override
    public final StartException failedToCreate(Throwable cause, String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToCreate$str(), name), cause);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToFindBroadcastSocketBinding$str() {
        return "WFLYMSGAMQ0029: Failed to find SocketBinding for broadcast binding: %s";
    }

    @Override
    public final StartException failedToFindBroadcastSocketBinding(String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToFindBroadcastSocketBinding$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToFindConnectorSocketBinding$str() {
        return "WFLYMSGAMQ0030: Failed to find SocketBinding for connector: %s";
    }

    @Override
    public final StartException failedToFindConnectorSocketBinding(String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToFindConnectorSocketBinding$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToFindDiscoverySocketBinding$str() {
        return "WFLYMSGAMQ0031: Failed to find SocketBinding for discovery binding: %s";
    }

    @Override
    public final StartException failedToFindDiscoverySocketBinding(String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToFindDiscoverySocketBinding$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToShutdownServer$str() {
        return "WFLYMSGAMQ0032: Failed to shutdown %s server";
    }

    @Override
    public final RuntimeException failedToShutdownServer(Throwable cause, String server) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToShutdownServer$str(), server), cause);
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToStartService$str() {
        return "WFLYMSGAMQ0033: Failed to start service";
    }

    @Override
    public final StartException failedToStartService(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartService$str(), new Object[0]), cause);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalValue$str() {
        return "WFLYMSGAMQ0036: Illegal value %s for element %s";
    }

    @Override
    public final String illegalValue(Object value, String element) {
        return String.format(this.getLoggingLocale(), this.illegalValue$str(), value, element);
    }

    protected String immutableResource$str() {
        return "WFLYMSGAMQ0037: Resource is immutable";
    }

    @Override
    public final UnsupportedOperationException immutableResource() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.immutableResource$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalid$str() {
        return "WFLYMSGAMQ0038: %s is invalid";
    }

    @Override
    public final String invalid(Object obj) {
        return String.format(this.getLoggingLocale(), this.invalid$str(), obj);
    }

    protected String invalidAttributeType$str() {
        return "WFLYMSGAMQ0039: Attribute %s has unexpected type %s";
    }

    @Override
    public final IllegalStateException invalidAttributeType(String name, ModelType type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidAttributeType$str(), name, type));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidServiceState$str() {
        return "WFLYMSGAMQ0042: Service %s is not in state %s, it is in state %s";
    }

    @Override
    public final IllegalStateException invalidServiceState(ServiceName service, ServiceController.State validState, ServiceController.State currentState) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.invalidServiceState$str(), service, validState, currentState));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jndiNameAlreadyRegistered$str() {
        return "WFLYMSGAMQ0043: JNDI name %s is already registered";
    }

    @Override
    public final String jndiNameAlreadyRegistered(String jndiName) {
        return String.format(this.getLoggingLocale(), this.jndiNameAlreadyRegistered$str(), jndiName);
    }

    protected String required1$str() {
        return "WFLYMSGAMQ0045: %s is required";
    }

    @Override
    public final String required(Object obj) {
        return String.format(this.getLoggingLocale(), this.required1$str(), obj);
    }

    protected String required2$str() {
        return "WFLYMSGAMQ0046: Either %s or %s is required";
    }

    @Override
    public final String required(Object obj1, Object obj2) {
        return String.format(this.getLoggingLocale(), this.required2$str(), obj1, obj2);
    }

    protected String nullVar$str() {
        return "WFLYMSGAMQ0047: %s is null";
    }

    @Override
    public final IllegalArgumentException nullVar(String varName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), varName));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedAttribute$str() {
        return "WFLYMSGAMQ0050: Read support for attribute %s was not properly implemented";
    }

    @Override
    public final IllegalStateException unsupportedAttribute(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unsupportedAttribute$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedOperation$str() {
        return "WFLYMSGAMQ0052: Support for operation %s was not properly implemented";
    }

    @Override
    public final IllegalStateException unsupportedOperation(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unsupportedOperation$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedRuntimeAttribute$str() {
        return "WFLYMSGAMQ0053: Runtime handling for %s is not implemented";
    }

    @Override
    public final UnsupportedOperationException unsupportedRuntimeAttribute(String name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedRuntimeAttribute$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String activeMQServerNotInstalled$str() {
        return "WFLYMSGAMQ0054: No ActiveMQ Server is available under name %s";
    }

    @Override
    public final OperationFailedException activeMQServerNotInstalled(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.activeMQServerNotInstalled$str(), name));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotParseDeployment$str() {
        return "WFLYMSGAMQ0055: Could not parse file %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotParseDeployment(String file, Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotParseDeployment$str(), file), cause);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String operationNotValid$str() {
        return "WFLYMSGAMQ0056: Handler cannot handle operation %s";
    }

    @Override
    public final IllegalStateException operationNotValid(String operation) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.operationNotValid$str(), operation));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDestinationRegisteredForAddress$str() {
        return "WFLYMSGAMQ0057: No message destination registered at address %s";
    }

    @Override
    public final String noDestinationRegisteredForAddress(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.noDestinationRegisteredForAddress$str(), address);
    }

    protected String securityDomainContextNotSet$str() {
        return "WFLYMSGAMQ0058: SecurityDomainContext has not been set";
    }

    @Override
    public final IllegalStateException securityDomainContextNotSet() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.securityDomainContextNotSet$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToRecover$str() {
        return "WFLYMSGAMQ0060: Failed to recover %s";
    }

    @Override
    public final OperationFailedException failedToRecover(Throwable cause, String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToRecover$str(), name), cause);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String canNotRegisterResourceOfType$str() {
        return "WFLYMSGAMQ0063: Resources of type %s cannot be registered";
    }

    @Override
    public final UnsupportedOperationException canNotRegisterResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.canNotRegisterResourceOfType$str(), childType));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String canNotRemoveResourceOfType$str() {
        return "WFLYMSGAMQ0064: Resources of type %s cannot be removed";
    }

    @Override
    public final UnsupportedOperationException canNotRemoveResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.canNotRemoveResourceOfType$str(), childType));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serverInBackupMode$str() {
        return "WFLYMSGAMQ0066: Resource at the address %s can not be managed, the server is in backup mode";
    }

    @Override
    public final String serverInBackupMode(PathAddress address) {
        return String.format(this.getLoggingLocale(), this.serverInBackupMode$str(), address);
    }

    protected String wrongConnectorRefInBroadCastGroup$str() {
        return "WFLYMSGAMQ0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    }

    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(String bgName, String connectorRef, Collection<String> presentConnectors) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String callNotPermittedOnInjectedJMSContext$str() {
        return "WFLYMSGAMQ0068: It is not permitted to call this method on injected JMSContext (see Jakarta Messaging 2.0 spec, \u00a712.4.5).";
    }

    @Override
    public final IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(this.getLoggingLocale(), this.callNotPermittedOnInjectedJMSContext$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void noMatchingExpiryAddress(String address, String addressSettings) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMatchingExpiryAddress$str(), (Object)address, (Object)addressSettings);
    }

    protected String noMatchingExpiryAddress$str() {
        return "WFLYMSGAMQ0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    }

    @Override
    public final void noMatchingDeadLetterAddress(String address, String addressSettings) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noMatchingDeadLetterAddress$str(), (Object)address, (Object)addressSettings);
    }

    protected String noMatchingDeadLetterAddress$str() {
        return "WFLYMSGAMQ0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    }

    protected String canNotRemoveLastJNDIName$str() {
        return "WFLYMSGAMQ0073: Can not remove JNDI name %s. The resource must have at least one JNDI name";
    }

    @Override
    public final String canNotRemoveLastJNDIName(String jndiName) {
        return String.format(this.getLoggingLocale(), this.canNotRemoveLastJNDIName$str(), jndiName);
    }

    @Override
    public final void aioInfoLinux() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.aioInfoLinux$str(), new Object[0]);
    }

    protected String aioInfoLinux$str() {
        return "WFLYMSGAMQ0075: AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal and achieve optimal performance.";
    }

    protected String duplicateElements$str() {
        return "WFLYMSGAMQ0076: Parameter %s contains duplicate elements [%s]";
    }

    @Override
    public final OperationFailedException duplicateElements(String parameterName, ModelNode elements) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.duplicateElements$str(), parameterName, elements));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String canNotRemoveUnknownEntry$str() {
        return "WFLYMSGAMQ0077: Can not remove unknown entry %s";
    }

    @Override
    public final OperationFailedException canNotRemoveUnknownEntry(String entry) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.canNotRemoveUnknownEntry$str(), entry));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String onlyOneChildIsAllowed$str() {
        return "WFLYMSGAMQ0078: Only one %s child resource is allowed, found children: %s";
    }

    @Override
    public final OperationFailedException onlyOneChildIsAllowed(String childType, Set<String> childrenNames) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.onlyOneChildIsAllowed$str(), childType, childrenNames));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return "WFLYMSGAMQ0079: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement address) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), address));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String discoveryGroupIsNotDefined$str() {
        return "WFLYMSGAMQ0080: Discovery group %s is not defined";
    }

    @Override
    public final StartException discoveryGroupIsNotDefined(String discoveryGroupName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.discoveryGroupIsNotDefined$str(), discoveryGroupName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedBroadcastGroupConfigurationForLegacy$str() {
        return "WFLYMSGAMQ0081: Unsupported type of broadcast group configuration for legacy resource: %s";
    }

    @Override
    public final StartException unsupportedBroadcastGroupConfigurationForLegacy(String broadcastGroupConfigurationClassName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unsupportedBroadcastGroupConfigurationForLegacy$str(), broadcastGroupConfigurationClassName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedConnectorFactoryForLegacy$str() {
        return "WFLYMSGAMQ0082: Unsupported type of connector factory for legacy resource: %s";
    }

    @Override
    public final StartException unsupportedConnectorFactoryForLegacy(String connectorFactoryClassName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unsupportedConnectorFactoryForLegacy$str(), connectorFactoryClassName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String managementOperationAllowedOnlyInRunningMode$str() {
        return "WFLYMSGAMQ0083: The %s operation can not be performed: the server must be in %s mode";
    }

    @Override
    public final OperationFailedException managementOperationAllowedOnlyInRunningMode(String operationName, RunningMode mode) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.managementOperationAllowedOnlyInRunningMode$str(), operationName, mode));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noInVMConnector$str() {
        return "WFLYMSGAMQ0084: The server does not define any in-vm connector. One is required to be able to import a journal";
    }

    @Override
    public final OperationFailedException noInVMConnector() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noInVMConnector$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadClassFromModule$str() {
        return "WFLYMSGAMQ0085: Unable to load class %s from module %s";
    }

    @Override
    public final OperationFailedException unableToLoadClassFromModule(String className, String moduleName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadClassFromModule$str(), className, moduleName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadModule$str() {
        return "WFLYMSGAMQ0086: Unable to load module %s";
    }

    @Override
    public final OperationFailedException unableToLoadModule(String moduleName, ModuleLoadException cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadModule$str(), moduleName), (Throwable)cause);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToLoadConnectorServiceFactoryClass$str() {
        return "WFLYMSGAMQ0087: Unable to load connector service factory class: %s";
    }

    @Override
    public final OperationFailedException unableToLoadConnectorServiceFactoryClass(String factroyClass) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadConnectorServiceFactoryClass$str(), factroyClass));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidModularParameterValue$str() {
        return "WFLYMSGAMQ0088: %s is an invalid value for parameter %s, it should be multiple of %s";
    }

    @Override
    public final OperationFailedException invalidModularParameterValue(long size, String parameterName, long modular) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidModularParameterValue$str(), size, parameterName, modular));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void invalidConfiguration(PathAddress address, String definedAttribute, List<String> otherAttributes) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidConfiguration$str(), (Object)address, (Object)definedAttribute, otherAttributes);
    }

    protected String invalidConfiguration$str() {
        return "WFLYMSGAMQ0089: Resource at %s is not correctly configured: when its attribute %s is defined, the other attributes %s will not be taken into account";
    }

    protected String invalidNullSecurityDomain$str() {
        return "WFLYMSGAMQ0090: The Elytron security domain cannot be null";
    }

    @Override
    public final IllegalArgumentException invalidNullSecurityDomain() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNullSecurityDomain$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedAuthenticationWithException(Throwable cause, String username, String message) {
        this.log.logf(FQCN, Logger.Level.DEBUG, cause, this.failedAuthenticationWithException$str(), (Object)username, (Object)message);
    }

    protected String failedAuthenticationWithException$str() {
        return "WFLYMSGAMQ0091: Failed to authenticate username %s. Exception message: %s";
    }

    @Override
    public final void failedAuthentication(String username) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedAuthentication$str(), (Object)username);
    }

    protected String failedAuthentication$str() {
        return "WFLYMSGAMQ0092: Failed to authenticate username %s: cannot verify username/password pair";
    }

    @Override
    public final void failedAuthorization(String username) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.failedAuthorization$str(), (Object)username);
    }

    protected String failedAuthorization$str() {
        return "WFLYMSGAMQ0093: Failed to authorize username %s: missing permissions";
    }

    @Override
    public final void jdbcDatabaseDialectDetectionFailed(String databaseDialects) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jdbcDatabaseDialectDetectionFailed$str(), (Object)databaseDialects);
    }

    protected String jdbcDatabaseDialectDetectionFailed$str() {
        return "WFLYMSGAMQ0094: Unable to detect database dialect from connection metadata or JDBC driver name. Please configure this manually using the 'journal-database' property in your configuration.  Known database dialect strings are %s";
    }

    @Override
    public final void multipleClientMappingsFound(String socketBindingName, String transportConfigName, String host, int port) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleClientMappingsFound$str(), new Object[]{socketBindingName, transportConfigName, host, port});
    }

    protected String multipleClientMappingsFound$str() {
        return "WFLYMSGAMQ0095: Multiple client-mapping found in [%s] socket binding used by ActiveMQ [%s] transport configuration. Using address: [host: %s, port %s]";
    }

    protected String operationNotAllowedOnJdbcStore$str() {
        return "WFLYMSGAMQ0096: The %s operation can not be performed on a JDBC store journal";
    }

    @Override
    public final OperationFailedException operationNotAllowedOnJdbcStore(String operationName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.operationNotAllowedOnJdbcStore$str(), operationName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noSocketBinding$str() {
        return "WFLYMSGAMQ0097: There is no socket-binding or outbound-socket-binding configured with the name %s";
    }

    @Override
    public final OperationFailedException noSocketBinding(String connectorSocketBinding) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noSocketBinding$str(), connectorSocketBinding));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String moduleNotFound$str() {
        return "WFLYMSGAMQ0098: Unable to load module %s - the module or one of its dependencies is missing [%s]";
    }

    @Override
    public final OperationFailedException moduleNotFound(String moduleName, String missingModule, ModuleNotFoundException e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.moduleNotFound$str(), moduleName, missingModule), (Throwable)e);
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String remoteDestinationCreationFailed$str() {
        return "WFLYMSGAMQ0099: Creating the remote destination %s failed with error %s";
    }

    @Override
    public final StartException remoteDestinationCreationFailed(String destinationName, String error) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.remoteDestinationCreationFailed$str(), destinationName, error));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String remoteDestinationDeletionFailed$str() {
        return "WFLYMSGAMQ0100: Deleting the remote destination %s failed with error %s";
    }

    @Override
    public final RuntimeException remoteDestinationDeletionFailed(String destinationName, String error) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.remoteDestinationDeletionFailed$str(), destinationName, error));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidTransactionNameValue(String value, String name, Collection<?> validValues) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidTransactionNameValue$str(), (Object)value, (Object)name, validValues);
    }

    protected String invalidTransactionNameValue$str() {
        return "WFLYMSGAMQ0101: Invalid value %s for %s, legal values are %s, default value is applied.";
    }

    protected String upgradeRequestMissingKey$str() {
        return "WFLYMSGAMQ0102: HTTP Upgrade request missing Sec-JbossRemoting-Key header";
    }

    @Override
    public final IOException upgradeRequestMissingKey() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.upgradeRequestMissingKey$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String brokerNotStarted$str() {
        return "WFLYMSGAMQ0103: Broker is not started. It cannot be managed yet.";
    }

    @Override
    public final IllegalStateException brokerNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.brokerNotStarted$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String legacySecurityUnsupported$str() {
        return "WFLYMSGAMQ0104: Legacy security is no longer supported.";
    }

    @Override
    public final IllegalStateException legacySecurityUnsupported() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.legacySecurityUnsupported$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String socketBindingMulticastNotSet$str() {
        return "WFLYMSGAMQ0105: The %s %s is configured to use socket-binding %s, but this socket binding doesn't have the multicast-address or a multicast-port attributes configured.";
    }

    @Override
    public final OperationFailedException socketBindingMulticastNotSet(String resourceType, String resourceName, String socketBindingName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.socketBindingMulticastNotSet$str(), resourceType, resourceName, socketBindingName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedBridgeDeployment$str() {
        return "WFLYMSGAMQ0106: The bridge %s didn't deploy.";
    }

    @Override
    public final OperationFailedException failedBridgeDeployment(String bridgeName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedBridgeDeployment$str(), bridgeName));
        MessagingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String securityEnabledWithoutDomain$str() {
        return "WFLYMSGAMQ0107: You must define a elytron security doman when security is enabled.";
    }

    @Override
    public final IllegalStateException securityEnabledWithoutDomain() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.securityEnabledWithoutDomain$str(), new Object[0]));
        MessagingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

