/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.annotation.PostConstruct;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.SecurityContext;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.glassfish.soteria.authorization.spi.CallerDetailsResolver;
import org.glassfish.soteria.authorization.spi.ResourceAccessResolver;
import org.glassfish.soteria.authorization.spi.impl.JaccResourceAccessResolver;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;
import org.wildfly.security.soteria.integration.ElytronCallerDetailsResolver;

public class SecurityContextImpl
implements SecurityContext,
Serializable {
    public static final Set<String> ALL_HTTP_METHODS;
    public static final String[] ALL_HTTP_METHOD_NAMES;
    private static final long serialVersionUID = 1L;
    private CallerDetailsResolver callerDetailsResolver;
    private ResourceAccessResolver resourceAccessResolver;

    @PostConstruct
    public void init() {
        this.callerDetailsResolver = new ElytronCallerDetailsResolver();
        this.resourceAccessResolver = new JaccResourceAccessResolver();
    }

    public Principal getCallerPrincipal() {
        return this.callerDetailsResolver.getCallerPrincipal();
    }

    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> pType) {
        return this.callerDetailsResolver.getPrincipalsByType(pType);
    }

    public boolean isCallerInRole(String role) {
        return this.callerDetailsResolver.isCallerInRole(role);
    }

    public Set<String> getAllDeclaredCallerRoles() {
        return this.callerDetailsResolver.getAllDeclaredCallerRoles();
    }

    public boolean hasAccessToWebResource(String resource, String ... methods) {
        String[] substititeMethods = methods == null || methods.length == 0 ? ALL_HTTP_METHOD_NAMES : methods;
        return this.resourceAccessResolver.hasAccessToWebResource(resource, substititeMethods);
    }

    public AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationParameters parameters) {
        try {
            if (Jaspic.authenticate((HttpServletRequest)request, (HttpServletResponse)response, (AuthenticationParameters)parameters)) {
                return AuthenticationStatus.SUCCESS;
            }
            return Jaspic.getLastAuthenticationStatus((HttpServletRequest)request);
        }
        catch (IllegalArgumentException e) {
            return AuthenticationStatus.SEND_FAILURE;
        }
    }

    static {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.add("GET");
        tmp.add("POST");
        tmp.add("PUT");
        tmp.add("DELETE");
        tmp.add("HEAD");
        tmp.add("OPTIONS");
        tmp.add("TRACE");
        ALL_HTTP_METHODS = Collections.unmodifiableSortedSet(tmp);
        ALL_HTTP_METHOD_NAMES = new String[ALL_HTTP_METHODS.size()];
        ALL_HTTP_METHODS.toArray(ALL_HTTP_METHOD_NAMES);
    }
}

