/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.KotlinConstants;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.callback.CallbackReader;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.operation.OperationReader;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementReader;
import io.smallrye.openapi.runtime.io.securityscheme.SecuritySchemeReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.io.tag.TagConstant;
import io.smallrye.openapi.runtime.io.tag.TagReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.ScannerSPILogging;
import io.smallrye.openapi.runtime.scanner.spi.ScannerSPIMessages;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public interface AnnotationScanner {
    public String getName();

    public OpenAPI scan(AnnotationScannerContext var1, OpenAPI var2);

    public boolean isAsyncResponse(MethodInfo var1);

    public boolean isPostMethod(MethodInfo var1);

    public boolean isDeleteMethod(MethodInfo var1);

    public boolean containsScannerAnnotations(List<AnnotationInstance> var1, List<AnnotationScannerExtension> var2);

    public void setContextRoot(String var1);

    default public boolean isMultipartOutput(Type returnType) {
        return false;
    }

    default public boolean isMultipartInput(Type inputType) {
        return false;
    }

    default public boolean isScannerInternalResponse(Type returnType) {
        return false;
    }

    default public boolean isScannerInternalParameter(Type parameterType) {
        return false;
    }

    default public boolean isWrapperType(Type type) {
        return false;
    }

    default public Type unwrapType(Type type) {
        if (this.isWrapperType(type)) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    default public void processDefinitionAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        AnnotationInstance openApiDefAnno = DefinitionReader.getDefinitionAnnotation(targetClass);
        if (openApiDefAnno != null) {
            DefinitionReader.processDefinition(context, openApi, openApiDefAnno);
        }
    }

    default public void processSecuritySchemeAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        List<AnnotationInstance> securitySchemeAnnotations = SecuritySchemeReader.getSecuritySchemeAnnotations((AnnotationTarget)targetClass);
        for (AnnotationInstance annotation : securitySchemeAnnotations) {
            String name = SecuritySchemeReader.getSecuritySchemeName(annotation);
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name == null) continue;
            SecurityScheme securityScheme = SecuritySchemeReader.readSecurityScheme(context, annotation);
            Components components = ModelUtil.components(openApi);
            components.addSecurityScheme(name, securityScheme);
        }
    }

    default public void processServerAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        List<AnnotationInstance> serverAnnotations = ServerReader.getServerAnnotations((AnnotationTarget)targetClass);
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = ServerReader.readServer(context, annotation);
            openApi.addServer(server);
        }
    }

    default public void processJavaSecurity(ClassInfo resourceClass, OpenAPI openApi) {
        JavaSecurityProcessor.register(openApi);
        JavaSecurityProcessor.addDeclaredRolesToScopes((String[])TypeUtil.getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.DECLARE_ROLES));
        JavaSecurityProcessor.addRolesAllowedToScopes((String[])TypeUtil.getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.ROLES_ALLOWED));
    }

    default public void processOperationTags(AnnotationScannerContext context, MethodInfo method, OpenAPI openApi, Set<String> resourceTags, Operation operation) {
        Set<String> tags = this.processTags(context, (AnnotationTarget)method, openApi, true);
        if (tags == null) {
            if (!resourceTags.isEmpty()) {
                operation.setTags(new ArrayList<String>(resourceTags));
            }
        } else if (!tags.isEmpty()) {
            operation.setTags(new ArrayList<String>(tags));
        }
    }

    default public Set<String> processTags(AnnotationScannerContext context, AnnotationTarget target, OpenAPI openApi, boolean nullWhenMissing) {
        if (!TagReader.hasTagAnnotation(target)) {
            return nullWhenMissing ? null : Collections.emptySet();
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        List<AnnotationInstance> tagAnnos = TagReader.getTagAnnotations(target);
        for (AnnotationInstance ta : tagAnnos) {
            if (JandexUtil.isRef(ta)) {
                tags.add((String)JandexUtil.value(ta, "ref"));
                continue;
            }
            Tag tag = TagReader.readTag(context, ta);
            if (tag.getName() == null) continue;
            ModelUtil.addTag(openApi, tag);
            tags.add(tag.getName());
        }
        String[] refs = (String[])TypeUtil.getAnnotationValue(target, TagConstant.DOTNAME_TAGS, "refs");
        if (refs != null) {
            Arrays.stream(refs).forEach(tags::add);
        }
        return tags;
    }

    default public List<MethodInfo> getResourceMethods(AnnotationScannerContext context, ClassInfo resource) {
        Type resourceType = Type.create((DotName)resource.name(), (Type.Kind)Type.Kind.CLASS);
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(context.getIndex(), resource, resourceType);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (ClassInfo classInfo : chain.keySet()) {
            classInfo.methods().stream().filter(method -> !method.isSynthetic()).forEach(methods::add);
            JandexUtil.interfaces(context.getAugmentedIndex(), classInfo).stream().filter(type -> !TypeUtil.knownJavaType(type.name())).map(context.getAugmentedIndex()::getClass).filter(Objects::nonNull).flatMap(iface -> iface.methods().stream()).forEach(methods::add);
        }
        return methods;
    }

    default public Optional<Operation> processOperation(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method) {
        MethodInfo conflictingMethod;
        String operationId;
        if (OperationReader.operationIsHidden(method)) {
            return Optional.empty();
        }
        AnnotationInstance operationAnnotation = OperationReader.getOperationAnnotation(method);
        OperationImpl operation = (OperationImpl)OperationReader.readOperation(context, operationAnnotation, method);
        if (operation == null) {
            operation = new OperationImpl();
        }
        operation.setMethodRef(JandexUtil.createUniqueMethodReference(resourceClass, method));
        TypeUtil.mapDeprecated((AnnotationTarget)method, operation::getDeprecated, operation::setDeprecated);
        TypeUtil.mapDeprecated((AnnotationTarget)resourceClass, operation::getDeprecated, operation::setDeprecated);
        OpenApiConfig.OperationIdStrategy operationIdStrategy = context.getConfig().getOperationIdStrategy();
        if (operationIdStrategy != null && operation.getOperationId() == null) {
            operationId = null;
            switch (operationIdStrategy) {
                case METHOD: {
                    operationId = method.name();
                    break;
                }
                case CLASS_METHOD: {
                    operationId = resourceClass.name().withoutPackagePrefix() + "_" + method.name();
                    break;
                }
                case PACKAGE_CLASS_METHOD: {
                    operationId = resourceClass.name() + "_" + method.name();
                    break;
                }
            }
            operation.setOperationId(operationId);
        }
        if ((operationId = operation.getOperationId()) != null && (conflictingMethod = context.getOperationIdMap().putIfAbsent(operationId, method)) != null) {
            ClassInfo conflictingClass = conflictingMethod.declaringClass();
            String className = resourceClass.name().toString();
            String methodName = method.toString();
            String conflictingClassName = conflictingClass.name().toString();
            String conflictingMethodName = conflictingMethod.toString();
            if (context.getConfig().getDuplicateOperationIdBehavior() == OpenApiConfig.DuplicateOperationIdBehavior.WARN) {
                ScannerSPILogging.log.duplicateOperationId(operationId, className, methodName, conflictingClassName, conflictingMethodName);
            } else {
                throw ScannerSPIMessages.msg.duplicateOperationId(operationId, className, methodName, conflictingClassName, conflictingMethodName);
            }
        }
        return Optional.of(operation);
    }

    default public void setJsonViewContext(AnnotationScannerContext context, Type[] views) {
        this.clearJsonViewContext(context);
        if (views != null && views.length > 0) {
            AugmentedIndexView index = context.getAugmentedIndex();
            Arrays.stream(views).map(viewType -> {
                if (index.containsClass((Type)viewType)) {
                    return JandexUtil.inheritanceChain(index, index.getClass((Type)viewType), viewType).values();
                }
                return Collections.singleton(viewType);
            }).flatMap(Collection::stream).forEach(context.getJsonViews()::add);
        }
    }

    default public void clearJsonViewContext(AnnotationScannerContext context) {
        context.getJsonViews().clear();
    }

    default public void processResponse(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, Operation operation, Map<DotName, List<AnnotationInstance>> exceptionAnnotationMap) {
        this.setJsonViewContext(context, (Type[])TypeUtil.getDeclaredAnnotationValue((AnnotationTarget)method, JacksonConstants.JSON_VIEW));
        List<AnnotationInstance> classApiResponseAnnotations = ResponseReader.getResponseAnnotations((AnnotationTarget)resourceClass);
        for (AnnotationInstance annotationInstance : classApiResponseAnnotations) {
            this.addApiReponseFromAnnotation(context, annotationInstance, operation);
        }
        List<AnnotationInstance> methodApiResponseAnnotations = ResponseReader.getResponseAnnotations((AnnotationTarget)method);
        for (AnnotationInstance annotation : methodApiResponseAnnotations) {
            this.addApiReponseFromAnnotation(context, annotation, operation);
        }
        AnnotationInstance annotationInstance = ResponseReader.getResponseSchemaAnnotation(method);
        this.addApiReponseSchemaFromAnnotation(context, annotationInstance, method, operation);
        AnnotationInstance apiResponses = ResponseReader.getResponsesAnnotation(method);
        if (apiResponses == null || !JandexUtil.isEmpty(apiResponses)) {
            this.createResponseFromRestMethod(context, method, operation);
        }
        if (apiResponses != null) {
            ResponseReader.readResponsesExtensions(context, apiResponses, operation.getResponses());
        }
        List methodExceptions = method.exceptions();
        for (Type type : methodExceptions) {
            DotName exceptionDotName = type.name();
            if (exceptionAnnotationMap == null || exceptionAnnotationMap.isEmpty() || !exceptionAnnotationMap.containsKey(exceptionDotName)) continue;
            for (AnnotationInstance exMapperApiResponseAnnotation : exceptionAnnotationMap.get(exceptionDotName)) {
                if (this.responseCodeExistInMethodAnnotations(context, exMapperApiResponseAnnotation, methodApiResponseAnnotations)) continue;
                this.addApiReponseFromAnnotation(context, exMapperApiResponseAnnotation, operation);
            }
        }
        this.clearJsonViewContext(context);
    }

    default public void createResponseFromRestMethod(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        Type returnType = context.getResourceTypeResolver().resolve(method.returnType());
        APIResponse response = null;
        int status = this.getDefaultStatus(method);
        String code = String.valueOf(status);
        String description = this.getReasonPhrase(status);
        if (this.isVoidResponse(method)) {
            if (this.generateResponse(code, operation)) {
                response = new APIResponseImpl().description(description);
            }
        } else if (this.generateResponse(code, operation)) {
            response = new APIResponseImpl().description(description);
            if (!(this.isScannerInternalResponse(returnType, context, method) || ModelUtil.responses(operation).getAPIResponse(code) != null && ModelUtil.responses(operation).getAPIResponse(code).getContent() != null)) {
                Schema schema = this.isMultipartOutput(returnType) ? new SchemaImpl().type(Schema.SchemaType.OBJECT) : (this.hasKotlinContinuation(method) ? this.kotlinContinuationToSchema(context, method) : SchemaFactory.typeToSchema(context, returnType, null, context.getExtensions()));
                ContentImpl content = new ContentImpl();
                String[] produces = CurrentScannerInfo.getCurrentProduces();
                if (produces == null || produces.length == 0) {
                    produces = context.getConfig().getDefaultProduces().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get());
                }
                if (schema != null && schema.getNullable() == null && TypeUtil.isOptional(returnType)) {
                    schema.setNullable(Boolean.TRUE);
                }
                for (String producesType : produces) {
                    MediaTypeImpl mt = new MediaTypeImpl();
                    mt.setSchema(schema);
                    content.addMediaType(producesType, mt);
                }
                response.setContent((Content)content);
            }
        }
        if (response != null) {
            APIResponses responses = ModelUtil.responses(operation);
            if (responses.hasAPIResponse(code)) {
                APIResponse responseFromAnnotations = responses.getAPIResponse(code);
                response = MergeUtil.mergeObjects(response, responseFromAnnotations);
            }
            responses.addAPIResponse(code, response);
        }
    }

    default public int getDefaultStatus(MethodInfo method) {
        int status = this.isVoidResponse(method) ? (this.isPostMethod(method) ? 201 : (!this.isAsyncResponse(method) ? 204 : 200)) : 200;
        return status;
    }

    default public boolean isVoidResponse(MethodInfo method) {
        Type returnType = method.returnType();
        if (returnType.kind().equals((Object)Type.Kind.VOID)) {
            return true;
        }
        if (this.isWrapperType(returnType)) {
            ParameterizedType parameterizedType = returnType.asParameterizedType();
            return parameterizedType.arguments().stream().anyMatch(TypeUtil::isVoid);
        }
        if (TypeUtil.isWrappedType(returnType)) {
            return TypeUtil.isVoid(TypeUtil.unwrapType(returnType));
        }
        return false;
    }

    default public boolean isScannerInternalResponse(Type returnType, AnnotationScannerContext context, MethodInfo method) {
        if (this.isScannerInternalResponse(returnType)) {
            return true;
        }
        return this.hasKotlinContinuation(method) && this.isScannerInternalResponse(this.getKotlinContinuationArgument(context, method));
    }

    default public boolean hasKotlinContinuation(MethodInfo method) {
        return method.parameterTypes().stream().anyMatch(this::isKotlinContinuation);
    }

    default public boolean isKotlinContinuation(Type paramType) {
        return KotlinConstants.CONTINUATION.equals((Object)paramType.name());
    }

    default public Type getKotlinContinuationArgument(AnnotationScannerContext context, MethodInfo method) {
        Type type = method.parameterTypes().stream().filter(this::isKotlinContinuation).findFirst().map(context.getResourceTypeResolver()::resolve).orElseThrow(() -> new IllegalStateException("Kotlin Continuation not present"));
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (type = (Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.WILDCARD_TYPE) {
            Type extendsBound = type.asWildcardType().extendsBound();
            Type superBound = type.asWildcardType().superBound();
            type = superBound != null ? superBound : extendsBound;
        }
        return type;
    }

    default public Schema kotlinContinuationToSchema(AnnotationScannerContext context, MethodInfo method) {
        Type type = this.getKotlinContinuationArgument(context, method);
        AnnotationInstance schemaAnnotation = JandexUtil.getMethodParameterAnnotation(method, type, SchemaConstant.DOTNAME_SCHEMA);
        return SchemaFactory.typeToSchema(context, type, schemaAnnotation, context.getExtensions());
    }

    default public boolean generateResponse(String status, Operation operation) {
        APIResponses responses = operation.getResponses();
        return responses == null || responses.getAPIResponse(status) != null;
    }

    default public void addApiReponseFromAnnotation(AnnotationScannerContext context, AnnotationInstance apiResponseAnnotation, Operation operation) {
        String responseCode = ResponseReader.getResponseName(context, apiResponseAnnotation);
        if (responseCode == null) {
            responseCode = "default";
        }
        APIResponse response = ResponseReader.readResponse(context, apiResponseAnnotation);
        APIResponses responses = ModelUtil.responses(operation);
        responses.addAPIResponse(responseCode, response);
    }

    default public void addApiReponseSchemaFromAnnotation(AnnotationScannerContext context, AnnotationInstance annotation, MethodInfo method, Operation operation) {
        int status;
        if (annotation == null) {
            return;
        }
        String responseCode = ResponseReader.getResponseName(context, annotation);
        if (responseCode != null && responseCode.matches("\\d{3}")) {
            status = Integer.parseInt(responseCode);
        } else {
            status = this.getDefaultStatus(method);
            responseCode = String.valueOf(status);
        }
        APIResponse response = ResponseReader.readResponseSchema(context, annotation);
        if (response.getDescription() == null) {
            response.setDescription(this.getReasonPhrase(status));
        }
        APIResponses responses = ModelUtil.responses(operation);
        responses.addAPIResponse(responseCode, response);
    }

    default public boolean responseCodeExistInMethodAnnotations(AnnotationScannerContext context, AnnotationInstance exMapperApiResponseAnnotation, List<AnnotationInstance> methodApiResponseAnnotations) {
        String exMapperResponseCode = ResponseReader.getResponseName(context, exMapperApiResponseAnnotation);
        return methodApiResponseAnnotations.stream().map(a -> ResponseReader.getResponseName(context, a)).filter(Objects::nonNull).anyMatch(code -> code.equals(exMapperResponseCode));
    }

    default public void processSecurityRequirementAnnotation(ClassInfo resourceClass, MethodInfo method, Operation operation) {
        SecurityRequirement requirement;
        List<AnnotationInstance> requirements = SecurityRequirementReader.getSecurityRequirementAnnotations((AnnotationTarget)method);
        List<AnnotationInstance> requirementSets = SecurityRequirementReader.getSecurityRequirementsSetAnnotations((AnnotationTarget)method);
        boolean emptyContainerPresent = this.isEmptySecurityRequirements((AnnotationTarget)method);
        if (requirements.isEmpty() && requirementSets.isEmpty() && !emptyContainerPresent) {
            requirements = SecurityRequirementReader.getSecurityRequirementAnnotations((AnnotationTarget)resourceClass);
            requirementSets = SecurityRequirementReader.getSecurityRequirementsSetAnnotations((AnnotationTarget)resourceClass);
            emptyContainerPresent = this.isEmptySecurityRequirements((AnnotationTarget)resourceClass);
        }
        for (AnnotationInstance annotation : requirements) {
            requirement = SecurityRequirementReader.readSecurityRequirement(annotation);
            if (requirement == null) continue;
            operation.addSecurityRequirement(requirement);
        }
        for (AnnotationInstance annotation : requirementSets) {
            requirement = SecurityRequirementReader.readSecurityRequirementsSet(annotation);
            if (requirement == null) continue;
            operation.addSecurityRequirement(requirement);
        }
        if (requirements.isEmpty() && requirementSets.isEmpty() && emptyContainerPresent) {
            operation.setSecurity(new ArrayList(0));
        }
    }

    default public boolean isEmptySecurityRequirements(AnnotationTarget target) {
        AnnotationInstance securityRequirementsSets;
        boolean foundEmptyAnnotation = false;
        AnnotationInstance securityRequirements = SecurityRequirementReader.getSecurityRequirementsAnnotation(target);
        if (securityRequirements != null) {
            AnnotationInstance[] values = (AnnotationInstance[])JandexUtil.value(securityRequirements, "value");
            if (values == null || values.length == 0) {
                foundEmptyAnnotation = true;
            } else {
                return false;
            }
        }
        if ((securityRequirementsSets = SecurityRequirementReader.getSecurityRequirementsSetsAnnotation(target)) != null) {
            AnnotationInstance[] values = (AnnotationInstance[])JandexUtil.value(securityRequirementsSets, "value");
            if (values == null || values.length == 0) {
                foundEmptyAnnotation = true;
            } else {
                return false;
            }
        }
        return foundEmptyAnnotation;
    }

    default public void processCallback(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<AnnotationInstance> callbackAnnotations = CallbackReader.getCallbackAnnotations((AnnotationTarget)method);
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        for (AnnotationInstance annotation : callbackAnnotations) {
            String name = CallbackReader.getCallbackName(annotation);
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name != null) {
                callbacks.put(name, CallbackReader.readCallback(context, annotation));
            }
            if (callbacks.isEmpty()) continue;
            operation.setCallbacks(callbacks);
        }
    }

    default public void processServerAnnotation(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<AnnotationInstance> serverAnnotations = ServerReader.getServerAnnotations((AnnotationTarget)method);
        if (serverAnnotations.isEmpty()) {
            serverAnnotations.addAll(ServerReader.getServerAnnotations((AnnotationTarget)method.declaringClass()));
        }
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = ServerReader.readServer(context, annotation);
            operation.addServer(server);
        }
    }

    default public void processExtensions(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<AnnotationInstance> extensionAnnotations = ExtensionReader.getExtensionsAnnotations((AnnotationTarget)method);
        if (extensionAnnotations.isEmpty()) {
            extensionAnnotations.addAll(ExtensionReader.getExtensionsAnnotations((AnnotationTarget)method.declaringClass()));
        }
        for (AnnotationInstance annotation : extensionAnnotations) {
            if (annotation.target() != null && AnnotationTarget.Kind.METHOD_PARAMETER.equals((Object)annotation.target().kind())) continue;
            String name = ExtensionReader.getExtensionName(annotation);
            operation.addExtension(name, ExtensionReader.readExtensionValue(context, name, annotation));
        }
    }

    default public void setOperationOnPathItem(PathItem.HttpMethod methodType, PathItem pathItem, Operation operation) {
        switch (methodType) {
            case DELETE: {
                pathItem.setDELETE(operation);
                break;
            }
            case GET: {
                pathItem.setGET(operation);
                break;
            }
            case HEAD: {
                pathItem.setHEAD(operation);
                break;
            }
            case OPTIONS: {
                pathItem.setOPTIONS(operation);
                break;
            }
            case PATCH: {
                pathItem.setPATCH(operation);
                break;
            }
            case POST: {
                pathItem.setPOST(operation);
                break;
            }
            case PUT: {
                pathItem.setPUT(operation);
                break;
            }
            case TRACE: {
                pathItem.setTRACE(operation);
                break;
            }
        }
    }

    default public void processScannerExtensions(AnnotationScannerContext context, Collection<ClassInfo> applications) {
        for (AnnotationScannerExtension extension : context.getExtensions()) {
            extension.processScannerApplications(this, applications);
        }
    }

    default public RequestBody processRequestBody(AnnotationScannerContext context, MethodInfo method, ResourceParameters params) {
        RequestBody requestBody = null;
        List<AnnotationInstance> requestBodyAnnotations = RequestBodyReader.getRequestBodyAnnotations((AnnotationTarget)method);
        for (AnnotationInstance annotation : requestBodyAnnotations) {
            AnnotationInstance schemaAnnotation;
            Schema schema;
            requestBody = RequestBodyReader.readRequestBody(context, annotation);
            Content formBodyContent = params.getFormBodyContent();
            if (formBodyContent != null) {
                requestBody.setContent(MergeUtil.mergeObjects(formBodyContent, requestBody.getContent()));
            }
            Type requestBodyType = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                requestBodyType = JandexUtil.getMethodParameterType(method, annotation.target().asMethodParameter().position());
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                requestBodyType = this.getRequestBodyParameterClassType(context, method, params);
            }
            if (requestBodyType == null || requestBody.getRef() != null) continue;
            Type[] views = (Type[])JandexUtil.value(JandexUtil.getMethodParameterAnnotation(method, requestBodyType, JacksonConstants.JSON_VIEW));
            this.setJsonViewContext(context, views);
            if (!ModelUtil.requestBodyHasSchema(requestBody) && (schema = SchemaFactory.typeToSchema(context, requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType), schemaAnnotation = JandexUtil.getMethodParameterAnnotation(method, requestBodyType, SchemaConstant.DOTNAME_SCHEMA), context.getExtensions())) != null) {
                ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
            }
            if (requestBody.getRequired() == null && TypeUtil.isOptional(requestBodyType)) {
                requestBody.setRequired(Boolean.FALSE);
            }
            this.setRequestBodyConstraints(context, requestBody, method, requestBodyType);
        }
        if (requestBody == null) {
            requestBody = RequestBodyReader.readRequestBodySchema(context, RequestBodyReader.getRequestBodySchemaAnnotation((AnnotationTarget)method));
        }
        if ((requestBody == null || requestBody.getContent() == null && requestBody.getRef() == null) && this.getConsumes(context) != null) {
            if (params.getFormBodyContent() != null) {
                if (requestBody == null) {
                    requestBody = new RequestBodyImpl();
                }
                requestBody.setContent(params.getFormBodyContent());
            } else {
                Type requestBodyType = this.getRequestBodyParameterClassType(context, method, params);
                requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType);
                if (requestBodyType != null && !this.isScannerInternalParameter(requestBodyType)) {
                    Type[] views = (Type[])JandexUtil.value(JandexUtil.getMethodParameterAnnotation(method, requestBodyType, JacksonConstants.JSON_VIEW));
                    this.setJsonViewContext(context, views);
                    SchemaImpl schema = null;
                    if (this.isMultipartInput(requestBodyType)) {
                        schema = new SchemaImpl();
                        schema.setType(Schema.SchemaType.OBJECT);
                    } else {
                        AnnotationInstance schemaAnnotation = JandexUtil.getMethodParameterAnnotation(method, requestBodyType, SchemaConstant.DOTNAME_SCHEMA);
                        schema = SchemaFactory.typeToSchema(context, requestBodyType, schemaAnnotation, context.getExtensions());
                    }
                    if (requestBody == null) {
                        requestBody = new RequestBodyImpl();
                    }
                    if (schema != null) {
                        ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
                    }
                    if (requestBody.getRequired() == null && TypeUtil.isOptional(requestBodyType)) {
                        requestBody.setRequired(Boolean.FALSE);
                    }
                    this.setRequestBodyConstraints(context, requestBody, method, requestBodyType);
                }
            }
        }
        this.clearJsonViewContext(context);
        return requestBody;
    }

    default public String[] getConsumes(AnnotationScannerContext context) {
        String[] currentConsumes = CurrentScannerInfo.getCurrentConsumes();
        if (currentConsumes == null || currentConsumes.length == 0) {
            currentConsumes = context.getConfig().getDefaultConsumes().orElse(null);
        }
        return currentConsumes;
    }

    default public Type getRequestBodyParameterClassType(AnnotationScannerContext context, MethodInfo method, ResourceParameters params) {
        List methodParams = method.parameterTypes();
        return IntStream.range(0, methodParams.size()).filter(position -> !this.isKotlinContinuation((Type)methodParams.get(position))).filter(position -> !this.isFrameworkContextType((Type)methodParams.get(position))).filter(position -> !this.isPathParameter(context, method.parameterName(position), params)).filter(position -> {
            List<AnnotationInstance> annotations = JandexUtil.getParameterAnnotations(method, (short)position);
            return annotations.isEmpty() || !this.containsScannerAnnotations(annotations, context.getExtensions());
        }).mapToObj(methodParams::get).findFirst().orElse(null);
    }

    default public void setRequestBodyConstraints(AnnotationScannerContext context, RequestBody requestBody, MethodInfo method, Type requestBodyType) {
        List<AnnotationInstance> paramAnnotations = JandexUtil.getMethodParameterAnnotations(method, requestBodyType);
        Optional<BeanValidationScanner> constraintScanner = context.getBeanValidationScanner();
        if (!paramAnnotations.isEmpty() && constraintScanner.isPresent()) {
            AnnotationTarget paramTarget = paramAnnotations.iterator().next().target();
            Optional.ofNullable(requestBody.getContent()).map(Content::getMediaTypes).map(Map::entrySet).orElseGet(Collections::emptySet).stream().map(Map.Entry::getValue).map(MediaType::getSchema).filter(Objects::nonNull).forEach(schema -> ((BeanValidationScanner)constraintScanner.get()).applyConstraints(paramTarget, (Schema)schema, null, (target, name) -> {
                if (requestBody.getRequired() == null) {
                    requestBody.setRequired(Boolean.TRUE);
                }
            }));
        }
    }

    default public boolean isPathParameter(AnnotationScannerContext context, String name, ResourceParameters params) {
        if (context.getConfig().allowNakedPathParameter().orElse(Boolean.FALSE).booleanValue()) {
            return params.getAllParameters().stream().map(p -> ModelUtil.dereference(context.getOpenApi(), p)).filter(p -> Objects.equals(p.getName(), name)).anyMatch(p -> Objects.equals(p.getIn(), Parameter.In.PATH));
        }
        return false;
    }

    default public boolean isFrameworkContextType(Type type) {
        return false;
    }

    default public String getReasonPhrase(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status";
            }
            case 208: {
                return "Already Reported";
            }
            case 226: {
                return "IM Used";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 308: {
                return "Permanent Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Payload Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 418: {
                return "I'm a teapot";
            }
            case 421: {
                return "Misdirected Request";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 424: {
                return "Failed Dependency";
            }
            case 426: {
                return "Upgrade Required";
            }
            case 428: {
                return "Precondition Required";
            }
            case 429: {
                return "Too Many Requests";
            }
            case 431: {
                return "Request Header Fields Too Large";
            }
            case 444: {
                return "Connection Closed Without Response";
            }
            case 451: {
                return "Unavailable For Legal Reasons";
            }
            case 499: {
                return "Client Closed Request";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 506: {
                return "Variant Also Negotiates";
            }
            case 507: {
                return "Insufficient Storage";
            }
            case 508: {
                return "Loop Detected";
            }
            case 510: {
                return "Not Extended";
            }
            case 511: {
                return "Network Authentication Required";
            }
            case 599: {
                return "Network Connect Timeout Error";
            }
        }
        return "Unknown";
    }
}

