/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.file;

import io.smallrye.config.common.MapBackedConfigSource;
import io.smallrye.config.source.file.FileSystemLogging;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystemConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = 654034634846856045L;
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

    public FileSystemConfigSource(File dir) {
        this(dir, 100);
    }

    public FileSystemConfigSource(String dir) {
        this(new File(dir), 100);
    }

    public FileSystemConfigSource(File dir, int ordinal) {
        super("FileSystemConfigSource[dir=" + dir.getAbsolutePath() + "]", FileSystemConfigSource.scan(dir), ordinal);
    }

    private static Map<String, String> scan(File directory) {
        if (directory != null && directory.isDirectory()) {
            Map<String, String> map;
            block9: {
                Stream<Path> stream = Files.walk(directory.toPath(), 1, new FileVisitOption[0]);
                try {
                    map = stream.filter(p -> p.toFile().isFile()).collect(Collectors.toMap(it -> it.getFileName().toString(), FileSystemConfigSource::readContent));
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        FileSystemLogging.log.failedToReadFileContent(directory.getAbsolutePath(), e.getLocalizedMessage());
                    }
                }
                stream.close();
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static String readContent(Path file) {
        String string;
        block8: {
            Stream<String> stream = Files.lines(file);
            try {
                string = stream.collect(Collectors.joining());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        Map properties = this.getProperties();
        String value = (String)properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = PATTERN.matcher(name).replaceAll("_");
        value = (String)properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return (String)properties.get(sanitizedName.toUpperCase());
    }
}

