/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ejb.infinispan.timer.TimerIndex;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum TimerIndexMarshaller implements ProtoStreamMarshaller<TimerIndex>
{
    INSTANCE;

    private static final int NO_PARAMETERS_DECLARING_CLASS_NAME_INDEX = 1;
    private static final int TIMER_PARAMETERS_DECLARING_CLASS_NAME_INDEX = 2;
    private static final int METHOD_NAME_INDEX = 3;
    private static final int INDEX_INDEX = 4;
    private static final String DEFAULT_METHOD_NAME = "ejbTimeout";
    private static final int DEFAULT_INDEX = 0;

    public Class<? extends TimerIndex> getJavaClass() {
        return TimerIndex.class;
    }

    public TimerIndex readFrom(ProtoStreamReader reader) throws IOException {
        String declaringClassName = null;
        String methodName = DEFAULT_METHOD_NAME;
        int parameters = 0;
        int index = 0;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 2: {
                    parameters = 1;
                }
                case 1: {
                    declaringClassName = reader.readString();
                    continue block5;
                }
                case 3: {
                    methodName = reader.readString();
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new TimerIndex(declaringClassName, methodName, parameters, index);
    }

    public void writeTo(ProtoStreamWriter writer, TimerIndex index) throws IOException {
        writer.writeString(index.getParameters() > 0 ? 2 : 1, index.getDeclaringClassName());
        String methodName = index.getMethodName();
        if (!methodName.equals(DEFAULT_METHOD_NAME)) {
            writer.writeString(3, methodName);
        }
        if (index.getIndex() != 0) {
            writer.writeUInt32(4, index.getIndex());
        }
    }
}

