/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.DiscoveryService;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.ejb.protocol.remote.RemoteEJBDiscoveryConfigurator;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.httpclient.ejb.HttpDiscoveryConfigurator;

public final class DiscoveryRegistrationProcessor
implements DeploymentUnitProcessor {
    private final boolean appClient;

    public DiscoveryRegistrationProcessor(boolean appClient) {
        this.appClient = appClient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ServiceName profileServiceName = (ServiceName)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_REMOTING_PROFILE_SERVICE_NAME);
        ServiceName discoveryServiceName = DiscoveryService.BASE_NAME.append(new String[]{deploymentUnit.getName()});
        ServiceBuilder builder = phaseContext.getServiceTarget().addService(discoveryServiceName);
        Consumer discoveryConsumer = builder.provides(new ServiceName[]{discoveryServiceName});
        Supplier remotingProfileServiceSupplier = profileServiceName != null ? builder.requires(profileServiceName) : null;
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = (EJBClientDescriptorMetaData)deploymentUnit.getAttachment(Attachments.EJB_CLIENT_METADATA);
        boolean useLocalReceiver = ejbClientDescriptorMetaData == null || ejbClientDescriptorMetaData.isLocalReceiverExcluded() != Boolean.TRUE;
        Supplier associationServiceSupplier = useLocalReceiver && !this.appClient ? builder.requires(AssociationService.SERVICE_NAME) : null;
        DiscoveryService discoveryService = new DiscoveryService(discoveryConsumer, remotingProfileServiceSupplier, associationServiceSupplier);
        new RemoteEJBDiscoveryConfigurator().configure(discoveryService.getDiscoveryProviderConsumer(), registryProvider -> {});
        new HttpDiscoveryConfigurator().configure(discoveryService.getDiscoveryProviderConsumer(), registryProvider -> {});
        builder.setInstance((Service)discoveryService);
        builder.install();
    }
}

