/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.network.OutboundConnection;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.discovery.ServiceURL;
import org.xnio.OptionMap;

public class RemotingProfileService
implements Service {
    private final List<ServiceURL> serviceUrls;
    private final Map<String, RemotingConnectionSpec> remotingConnectionSpecMap;
    private final List<HttpConnectionSpec> httpConnectionSpecs;
    private final Consumer<RemotingProfileService> consumer;
    private final Supplier<EJBTransportProvider> localTransportProviderSupplier;

    public RemotingProfileService(Consumer<RemotingProfileService> consumer, Supplier<EJBTransportProvider> localTransportProviderSupplier, List<ServiceURL> serviceUrls, Map<String, RemotingConnectionSpec> remotingConnectionSpecMap, List<HttpConnectionSpec> httpConnectionSpecs) {
        this.consumer = consumer;
        this.localTransportProviderSupplier = localTransportProviderSupplier;
        this.serviceUrls = serviceUrls;
        this.remotingConnectionSpecMap = remotingConnectionSpecMap;
        this.httpConnectionSpecs = httpConnectionSpecs;
    }

    public void start(StartContext context) throws StartException {
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.consumer.accept(null);
    }

    public Supplier<EJBTransportProvider> getLocalTransportProviderSupplier() {
        return this.localTransportProviderSupplier;
    }

    public Collection<RemotingConnectionSpec> getConnectionSpecs() {
        return this.remotingConnectionSpecMap.values();
    }

    public Collection<HttpConnectionSpec> getHttpConnectionSpecs() {
        return this.httpConnectionSpecs;
    }

    public List<ServiceURL> getServiceUrls() {
        return this.serviceUrls;
    }

    public static final class HttpConnectionSpec {
        private final String uri;

        public HttpConnectionSpec(String uri) {
            this.uri = uri;
        }

        public URI getUri() {
            try {
                return new URI(this.uri);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static final class RemotingConnectionSpec {
        private final String connectionName;
        private final Supplier<OutboundConnection> supplier;
        private final OptionMap connectOptions;
        private final long connectTimeout;

        public RemotingConnectionSpec(String connectionName, Supplier<OutboundConnection> supplier, OptionMap connectOptions, long connectTimeout) {
            this.connectionName = connectionName;
            this.supplier = supplier;
            this.connectOptions = connectOptions;
            this.connectTimeout = connectTimeout;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public Supplier<OutboundConnection> getSupplier() {
            return this.supplier;
        }

        public OptionMap getConnectOptions() {
            return this.connectOptions;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }
    }
}

