/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.service;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import io.narayana.lra.LRAConstants;
import io.narayana.lra.LRAData;
import io.narayana.lra.coordinator.domain.model.LRAParticipantRecord;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.logging.LRALogger;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class LRAService {
    private static final Pattern LINK_REL_PATTERN = Pattern.compile("(\\w+)=\"([^\"]+)\"|([^\\s]+)");
    private final Map<URI, LongRunningAction> lras = new ConcurrentHashMap<URI, LongRunningAction>();
    private final Map<URI, LongRunningAction> recoveringLRAs = new ConcurrentHashMap<URI, LongRunningAction>();
    private final Map<URI, ReentrantLock> locks = new ConcurrentHashMap<URI, ReentrantLock>();
    private final Map<String, String> participants = new ConcurrentHashMap<String, String>();
    private LRARecoveryModule recoveryModule;

    public LongRunningAction getTransaction(URI lraId) throws NotFoundException {
        if (!this.lras.containsKey(lraId)) {
            String uid = LRAConstants.getLRAUid((URI)lraId);
            if (uid == null || uid.isEmpty()) {
                String errorMsg = "Invalid transaction format of LRA id: " + lraId;
                throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMsg).build());
            }
            for (LongRunningAction lra : this.lras.values()) {
                if (!uid.equals(lra.get_uid().fileStringForm())) continue;
                return lra;
            }
            if (!this.recoveringLRAs.containsKey(lraId)) {
                for (LongRunningAction lra : this.recoveringLRAs.values()) {
                    if (!uid.equals(lra.get_uid().fileStringForm())) continue;
                    return lra;
                }
                String errorMsg = "Invalid transaction id: " + lraId;
                throw new NotFoundException(errorMsg, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMsg).build());
            }
            return this.recoveringLRAs.get(lraId);
        }
        return this.lras.get(lraId);
    }

    public LongRunningAction lookupTransaction(URI lraId) {
        try {
            return lraId == null ? null : this.getTransaction(lraId);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public LRAData getLRA(URI lraId) {
        LongRunningAction lra = this.getTransaction(lraId);
        return lra.getLRAData();
    }

    public synchronized ReentrantLock lockTransaction(URI lraId) {
        ReentrantLock lock = this.locks.computeIfAbsent(lraId, k -> new ReentrantLock());
        lock.lock();
        return lock;
    }

    public synchronized ReentrantLock tryLockTransaction(URI lraId) {
        ReentrantLock lock = this.locks.computeIfAbsent(lraId, k -> new ReentrantLock());
        return lock.tryLock() ? lock : null;
    }

    public List<LRAData> getAll() {
        return this.getAll(null);
    }

    public List<LRAData> getAll(LRAStatus lraStatus) {
        if (lraStatus == null) {
            List<LRAData> all = this.lras.values().stream().map(LongRunningAction::getLRAData).collect(Collectors.toList());
            all.addAll(this.getAllRecovering());
            return all;
        }
        List<LRAData> allByStatus = this.getDataByStatus(this.lras, lraStatus);
        allByStatus.addAll(this.getDataByStatus(this.recoveringLRAs, lraStatus));
        return allByStatus;
    }

    public List<LRAData> getAllRecovering(boolean scan) {
        if (scan) {
            RecoveryManager.manager().scan();
        }
        return this.recoveringLRAs.values().stream().map(LongRunningAction::getLRAData).collect(Collectors.toList());
    }

    public List<LRAData> getAllRecovering() {
        return this.getAllRecovering(false);
    }

    public void addTransaction(LongRunningAction lra) {
        this.lras.put(lra.getId(), lra);
    }

    public void finished(LongRunningAction transaction, boolean fromHierarchy) {
        if (transaction.isFailed()) {
            this.getRM().moveEntryToFailedLRAPath(transaction.get_uid());
        }
        if (transaction.isRecovering()) {
            this.recoveringLRAs.put(transaction.getId(), transaction);
        } else if ((fromHierarchy || transaction.isTopLevel()) && !transaction.hasPendingActions()) {
            this.remove(transaction);
        }
    }

    public boolean removeLog(String lraId) {
        String uid = LRAConstants.getLRAUid((String)lraId);
        try {
            return this.getRM().removeCommitted(new Uid(uid));
        }
        catch (Exception e) {
            LRALogger.i18nLogger.warn_cannotRemoveUidRecord(lraId, uid, (Throwable)e);
            return false;
        }
    }

    public void remove(LongRunningAction lra) {
        if (lra.isFailed()) {
            lra.deactivate();
        }
        this.remove(lra.getId());
    }

    public void remove(URI lraId) {
        this.lraTrace(lraId, "remove LRA");
        this.lras.remove(lraId);
        this.recoveringLRAs.remove(lraId);
        this.locks.remove(lraId);
    }

    public void recover() {
        this.getRM().recover();
    }

    public void updateRecoveryURI(URI lraId, String compensatorUrl, String recoveryURI, boolean persist) {
        assert (recoveryURI != null);
        assert (compensatorUrl != null);
        this.participants.put(recoveryURI, compensatorUrl);
        if (persist && lraId != null) {
            LongRunningAction transaction = this.getTransaction(lraId);
            transaction.updateRecoveryURI(compensatorUrl, recoveryURI);
        }
    }

    public String getParticipant(String rcvCoordId) {
        return this.participants.get(rcvCoordId);
    }

    public synchronized LongRunningAction startLRA(String baseUri, URI parentLRA, String clientId, Long timelimit) {
        LongRunningAction lra;
        try {
            lra = new LongRunningAction(this, baseUri, this.lookupTransaction(parentLRA), clientId);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("Invalid base URI: '%s'", baseUri)).build());
        }
        int status = lra.begin(timelimit);
        if (status != 0) {
            this.lraTrace(lra.getId(), "failed to start LRA");
            lra.finishLRA(true);
            String errorMsg = "Could not start LRA: " + ActionStatus.stringForm((int)status);
            throw new InternalServerErrorException(errorMsg, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)errorMsg).build());
        }
        this.addTransaction(lra);
        return lra;
    }

    public LRAData endLRA(URI lraId, boolean compensate, boolean fromHierarchy) {
        this.lraTrace(lraId, "end LRA");
        LongRunningAction transaction = this.getTransaction(lraId);
        if (transaction.getLRAStatus() != LRAStatus.Active && !transaction.isRecovering() && transaction.isTopLevel()) {
            String errorMsg = String.format("%s: LRA is closing or closed: endLRA", lraId);
            throw new WebApplicationException(errorMsg, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)errorMsg).build());
        }
        transaction.finishLRA(compensate);
        if (BasicAction.Current() != null && LRALogger.logger.isInfoEnabled()) {
            LRALogger.logger.infof("LRAServicve.endLRA LRA %s ended but is still associated with %s%n", (Object)lraId, (Object)BasicAction.Current().get_uid().fileStringForm());
        }
        this.finished(transaction, fromHierarchy);
        return transaction.getLRAData();
    }

    public int leave(URI lraId, String compensatorUrl) {
        boolean wasForgotten;
        this.lraTrace(lraId, "leave LRA");
        LongRunningAction transaction = this.getTransaction(lraId);
        if (transaction.getLRAStatus() != LRAStatus.Active) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        try {
            wasForgotten = transaction.forgetParticipant(compensatorUrl);
        }
        catch (Exception e) {
            String errorMsg = String.format("LRAService.forget %s failed on finding participant '%s'", lraId, compensatorUrl);
            throw new WebApplicationException(errorMsg, (Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build());
        }
        if (wasForgotten) {
            return Response.Status.OK.getStatusCode();
        }
        String errorMsg = String.format("LRAService.forget %s failed as the participant was not found, compensator url '%s'", lraId, compensatorUrl);
        throw new WebApplicationException(errorMsg, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).build());
    }

    public synchronized int joinLRA(StringBuilder recoveryUrl, URI lra, long timeLimit, String compensatorUrl, String linkHeader, String recoveryUrlBase, String compensatorData) {
        LRAParticipantRecord participant;
        if (lra == null) {
            this.lraTrace(null, "Error missing LRA header in join request");
        } else {
            this.lraTrace(lra, "join LRA");
        }
        LongRunningAction transaction = this.getTransaction(lra);
        if (timeLimit < 0L) {
            timeLimit = 0L;
        }
        if (transaction.getLRAStatus() != LRAStatus.Active && !transaction.isRecovering() && linkHeader != null) {
            Matcher relMatcher = LINK_REL_PATTERN.matcher(linkHeader);
            while (relMatcher.find()) {
                String rel;
                String key = relMatcher.group(1);
                if (key == null || !key.equals("rel")) continue;
                String string = rel = relMatcher.group(2) == null ? relMatcher.group(3) : relMatcher.group(2);
                if (!"after".equals(rel)) {
                    return Response.Status.PRECONDITION_FAILED.getStatusCode();
                }
                if (transaction.isRecovering()) continue;
                return Response.Status.PRECONDITION_FAILED.getStatusCode();
            }
        }
        try {
            participant = transaction.enlistParticipant(lra, linkHeader != null ? linkHeader : compensatorUrl, recoveryUrlBase, timeLimit, compensatorData);
        }
        catch (UnsupportedEncodingException e) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        if (participant == null || participant.getRecoveryURI() == null) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        String recoveryURI = participant.getRecoveryURI().toASCIIString();
        this.updateRecoveryURI(lra, participant.getParticipantURI(), recoveryURI, false);
        recoveryUrl.append(recoveryURI);
        return Response.Status.OK.getStatusCode();
    }

    public boolean hasTransaction(URI id) {
        return id != null && (this.lras.containsKey(id) || this.recoveringLRAs.containsKey(id));
    }

    public boolean hasTransaction(String id) {
        try {
            return this.lras.containsKey(new URI(id));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private void lraTrace(URI lraId, String reason) {
        if (LRALogger.logger.isTraceEnabled()) {
            if (lraId != null && this.lras.containsKey(lraId)) {
                LongRunningAction lra = this.lras.get(lraId);
                LRALogger.logger.tracef("LRAService: '%s' (%s) in state %s: %s%n", new Object[]{reason, lra.getClientId(), ActionStatus.stringForm((int)lra.status()), lra.getId()});
            } else {
                LRALogger.logger.tracef("LRAService: '%s', not found: %s%n", (Object)reason, (Object)lraId);
            }
        }
    }

    public int renewTimeLimit(URI lraId, Long timelimit) {
        LongRunningAction lra = this.lras.get(lraId);
        if (lra == null) {
            return Response.Status.NOT_FOUND.getStatusCode();
        }
        return lra.setTimeLimit(timelimit);
    }

    public List<LRAData> getFailedLRAs() {
        ConcurrentHashMap<URI, LongRunningAction> failedLRAs = new ConcurrentHashMap<URI, LongRunningAction>();
        this.getRM().getFailedLRAs(failedLRAs);
        return failedLRAs.values().stream().map(LongRunningAction::getLRAData).collect(Collectors.toList());
    }

    private LRARecoveryModule getRM() {
        if (this.recoveryModule != null) {
            return this.recoveryModule;
        }
        return LRARecoveryModule.getInstance();
    }

    private List<LRAData> getDataByStatus(Map<URI, LongRunningAction> lrasToFilter, LRAStatus status) {
        return lrasToFilter.values().stream().filter(t -> t.getLRAStatus() == status).map(LongRunningAction::getLRAData).collect(Collectors.toList());
    }
}

