/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.TransactionInProgressException;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XATopicSession;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ManagedConnection;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionRequestInfo;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageConsumer;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageProducer;
import org.apache.activemq.artemis.ra.ActiveMQRAQueueReceiver;
import org.apache.activemq.artemis.ra.ActiveMQRAQueueSender;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRATopicPublisher;
import org.apache.activemq.artemis.ra.ActiveMQRATopicSubscriber;

public class ActiveMQRASession
implements QueueSession,
TopicSession,
XAQueueSession,
XATopicSession {
    private ActiveMQRAManagedConnection mc;
    private final ActiveMQRAConnectionRequestInfo cri;
    private ActiveMQRASessionFactory sf;
    private final Set<MessageConsumer> consumers;
    private final Set<MessageProducer> producers;

    public ActiveMQRASession(ActiveMQRAManagedConnection mc, ActiveMQRAConnectionRequestInfo cri) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + mc + ", " + cri + ")");
        }
        this.mc = mc;
        this.cri = cri;
        this.sf = null;
        this.consumers = new HashSet<MessageConsumer>();
        this.producers = new HashSet<MessageProducer>();
    }

    public void setActiveMQSessionFactory(ActiveMQRASessionFactory sf) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setActiveMQSessionFactory(" + sf + ")");
        }
        this.sf = sf;
    }

    protected void lock() throws JMSException {
        ActiveMQRAManagedConnection mcLocal;
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("lock()");
        }
        if ((mcLocal = this.mc) == null) {
            throw new IllegalStateException("Connection is not associated with a managed connection. " + this);
        }
        mcLocal.tryLock();
    }

    protected void unlock() {
        ActiveMQRAManagedConnection mcLocal;
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("unlock()");
        }
        if ((mcLocal = this.mc) != null) {
            mcLocal.unlock();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createBytesMessage" + session);
        }
        return session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createMapMessage(), " + session);
        }
        return session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createMessage" + session);
        }
        return session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createObjectMessage" + session);
        }
        return session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createObjectMessage(" + object + ")" + session);
        }
        return session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createStreamMessage" + session);
        }
        return session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createTextMessage" + session);
        }
        return session.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createTextMessage(" + string + ")" + session);
        }
        return session.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getTransacted()");
        }
        this.getSessionInternal();
        return this.cri.isTransacted();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getMessageListener()");
        }
        throw new IllegalStateException("Method not allowed");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setMessageListener(" + listener + ")");
        }
        throw new IllegalStateException("Method not allowed");
    }

    public void run() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("run()");
        }
        throw new Error("Method not allowed");
    }

    public void close() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("close()");
        }
        this.sf.closeSession(this);
        this.closeSession();
    }

    public void commit() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("Commit session " + this);
            }
            session.commit();
        }
        finally {
            this.unlock();
        }
    }

    public void rollback() throws JMSException {
        if (this.cri.getType() == 3 || this.cri.getType() == 4 || this.cri.getType() == 5) {
            throw new TransactionInProgressException("XA connection");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (!this.cri.isTransacted()) {
                throw new IllegalStateException("Session is not transacted");
            }
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("Rollback session " + this);
            }
            session.rollback();
        }
        finally {
            this.unlock();
        }
    }

    public void recover() throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (this.cri.isTransacted()) {
                throw new IllegalStateException("Session is transacted");
            }
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("Recover session " + this);
            }
            session.recover();
        }
        finally {
            this.unlock();
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create topic for jakarta.jms.QueueSession");
        }
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createTopic " + session + " topicName=" + topicName);
        }
        Topic result = session.createTopic(topicName);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createdTopic " + session + " topic=" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSubscriber " + session + " topic=" + topic);
            }
            TopicSubscriber result = session.createSubscriber(topic);
            result = new ActiveMQRATopicSubscriber(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdSubscriber " + session + " ActiveMQTopicSubscriber=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSubscriber " + session + " topic=" + topic + " selector=" + messageSelector + " noLocal=" + noLocal);
            }
            TopicSubscriber result = session.createSubscriber(topic, messageSelector, noLocal);
            result = new ActiveMQRATopicSubscriber(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdSubscriber " + session + " ActiveMQTopicSubscriber=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create durable subscriber from jakarta.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name);
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name);
            result = new ActiveMQRATopicSubscriber(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdDurableSubscriber " + session + " ActiveMQTopicSubscriber=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createDurableSubscriber " + session + " topic=" + topic + " name=" + name + " selector=" + messageSelector + " noLocal=" + noLocal);
            }
            TopicSubscriber result = session.createDurableSubscriber(topic, name, messageSelector, noLocal);
            result = new ActiveMQRATopicSubscriber(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdDurableSubscriber " + session + " ActiveMQTopicSubscriber=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            TopicSubscriber topicSubscriber = result;
            return topicSubscriber;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.lock();
        try {
            TopicSession session = this.getTopicSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createPublisher " + session + " topic=" + topic);
            }
            TopicPublisher result = session.createPublisher(topic);
            result = new ActiveMQRATopicPublisher(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdPublisher " + session + " publisher=" + result);
            }
            this.addProducer((MessageProducer)result);
            TopicPublisher topicPublisher = result;
            return topicPublisher;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot create temporary topic for jakarta.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createTemporaryTopic " + session);
            }
            TemporaryTopic temp = session.createTemporaryTopic();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdTemporaryTopic " + session + " temp=" + temp);
            }
            this.sf.addTemporaryTopic(temp);
            TemporaryTopic temporaryTopic = temp;
            return temporaryTopic;
        }
        finally {
            this.unlock();
        }
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.cri.getType() == 1 || this.cri.getType() == 4) {
            throw new IllegalStateException("Cannot unsubscribe for jakarta.jms.QueueSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("unsubscribe " + session + " name=" + name);
            }
            session.unsubscribe(name);
        }
        finally {
            this.unlock();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for jakarta.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createBrowser " + session + " queue=" + queue);
        }
        QueueBrowser result = session.createBrowser(queue);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createdBrowser " + session + " browser=" + result);
        }
        return result;
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser for jakarta.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createBrowser " + session + " queue=" + queue + " selector=" + messageSelector);
        }
        QueueBrowser result = session.createBrowser(queue, messageSelector);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createdBrowser " + session + " browser=" + result);
        }
        return result;
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create browser or jakarta.jms.TopicSession");
        }
        Session session = this.getSessionInternal();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createQueue " + session + " queueName=" + queueName);
        }
        Queue result = session.createQueue(queueName);
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("createdQueue " + session + " queue=" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createReceiver " + session + " queue=" + queue);
            }
            QueueReceiver result = session.createReceiver(queue);
            result = new ActiveMQRAQueueReceiver(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdReceiver " + session + " receiver=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createReceiver " + session + " queue=" + queue + " selector=" + messageSelector);
            }
            QueueReceiver result = session.createReceiver(queue, messageSelector);
            result = new ActiveMQRAQueueReceiver(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdReceiver " + session + " receiver=" + result);
            }
            this.addConsumer((MessageConsumer)result);
            QueueReceiver queueReceiver = result;
            return queueReceiver;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.lock();
        try {
            QueueSession session = this.getQueueSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSender " + session + " queue=" + queue);
            }
            QueueSender result = session.createSender(queue);
            result = new ActiveMQRAQueueSender(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdSender " + session + " sender=" + result);
            }
            this.addProducer((MessageProducer)result);
            QueueSender queueSender = result;
            return queueSender;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.cri.getType() == 2 || this.cri.getType() == 5) {
            throw new IllegalStateException("Cannot create temporary queue for jakarta.jms.TopicSession");
        }
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createTemporaryQueue " + session);
            }
            TemporaryQueue temp = session.createTemporaryQueue();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdTemporaryQueue " + session + " temp=" + temp);
            }
            this.sf.addTemporaryQueue(temp);
            TemporaryQueue temporaryQueue = temp;
            return temporaryQueue;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createConsumer " + session + " dest=" + destination);
            }
            MessageConsumer result = session.createConsumer(destination);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector);
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createConsumer " + session + " dest=" + destination + " messageSelector=" + messageSelector + " noLocal=" + noLocal);
            }
            MessageConsumer result = session.createConsumer(destination, messageSelector, noLocal);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createProducer " + session + " dest=" + destination);
            }
            MessageProducer result = session.createProducer(destination);
            result = new ActiveMQRAMessageProducer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdProducer " + session + " producer=" + result);
            }
            this.addProducer(result);
            MessageProducer messageProducer = result;
            return messageProducer;
        }
        finally {
            this.unlock();
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getAcknowledgeMode()");
        }
        this.getSessionInternal();
        return this.cri.getAcknowledgeMode();
    }

    public XAResource getXAResource() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getXAResource()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            return null;
        }
        try {
            this.lock();
            XAResource xAResource = this.getXAResourceInternal();
            return xAResource;
        }
        catch (Throwable t) {
            XAResource xAResource = null;
            return xAResource;
        }
        finally {
            this.unlock();
        }
    }

    public String getNodeId() throws JMSException {
        ActiveMQSession session = (ActiveMQSession)this.getSessionInternal();
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)session.getCoreSession().getSessionFactory();
        return factory.getLiveNodeId();
    }

    public Session getSession() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getNonXAsession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    public QueueSession getQueueSession() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getQueueSession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    public TopicSession getTopicSession() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getTopicSession()");
        }
        if (this.cri.getType() == 0 || this.cri.getType() == 1 || this.cri.getType() == 2) {
            throw new IllegalStateException("Non XA connection");
        }
        this.lock();
        try {
            ActiveMQRASession activeMQRASession = this;
            return activeMQRASession;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSharedConsumer " + session + " topic=" + topic + ", sharedSubscriptionName=" + sharedSubscriptionName);
            }
            MessageConsumer result = session.createSharedConsumer(topic, sharedSubscriptionName);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSharedConsumer " + session + " topic=" + topic + ", sharedSubscriptionName=" + sharedSubscriptionName + ", messageSelector=" + messageSelector);
            }
            MessageConsumer result = session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSharedConsumer " + session + " topic=" + topic + ", name=" + name);
            }
            MessageConsumer result = session.createDurableConsumer(topic, name);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createDurableConsumer " + session + " topic=" + topic + ", name=" + name + ", messageSelector=" + messageSelector + ", noLocal=" + noLocal);
            }
            MessageConsumer result = session.createDurableConsumer(topic, name, messageSelector, noLocal);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSharedDurableConsumer " + session + " topic=" + topic + ", name=" + name);
            }
            MessageConsumer result = session.createSharedDurableConsumer(topic, name);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        this.lock();
        try {
            Session session = this.getSessionInternal();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createSharedDurableConsumer " + session + " topic=" + topic + ", name=" + name + ", messageSelector=" + messageSelector);
            }
            MessageConsumer result = session.createSharedDurableConsumer(topic, name, messageSelector);
            result = new ActiveMQRAMessageConsumer(result, this);
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("createdConsumer " + session + " consumer=" + result);
            }
            this.addConsumer(result);
            MessageConsumer messageConsumer = result;
            return messageConsumer;
        }
        finally {
            this.unlock();
        }
    }

    void setManagedConnection(ActiveMQRAManagedConnection managedConnection) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setManagedConnection(" + managedConnection + ")");
        }
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = managedConnection;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    void destroy() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("destroy()");
        }
        this.mc = null;
    }

    void start() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("start()");
        }
        if (this.mc != null) {
            this.mc.start();
        }
    }

    void stop() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("stop()");
        }
        if (this.mc != null) {
            this.mc.stop();
        }
    }

    void checkStrict() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("checkStrict()");
        }
        if (this.mc != null) {
            throw new IllegalStateException("This method is not applicable inside the application server. See the J2EE spec, e.g. J2EE1.4 Section 6.6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSession() throws JMSException {
        if (this.mc != null) {
            Iterator<MessageConsumer> i;
            ActiveMQRALogger.LOGGER.trace("Closing session");
            try {
                this.mc.stop();
            }
            catch (Throwable t) {
                ActiveMQRALogger.LOGGER.trace("Error stopping managed connection", t);
            }
            Set<MessageConsumer> t = this.consumers;
            synchronized (t) {
                i = this.consumers.iterator();
                while (i.hasNext()) {
                    ActiveMQRAMessageConsumer consumer = (ActiveMQRAMessageConsumer)i.next();
                    try {
                        consumer.closeConsumer();
                    }
                    catch (Throwable t2) {
                        ActiveMQRALogger.LOGGER.trace("Error closing consumer", t2);
                    }
                    i.remove();
                }
            }
            t = this.producers;
            synchronized (t) {
                i = this.producers.iterator();
                while (i.hasNext()) {
                    ActiveMQRAMessageProducer producer = (ActiveMQRAMessageProducer)i.next();
                    try {
                        producer.closeProducer();
                    }
                    catch (Throwable t3) {
                        ActiveMQRALogger.LOGGER.trace("Error closing producer", t3);
                    }
                    i.remove();
                }
            }
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 1);
            ev.setConnectionHandle((Object)this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer consumer) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("addConsumer(" + consumer + ")");
        }
        Set<MessageConsumer> set = this.consumers;
        synchronized (set) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer consumer) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("removeConsumer(" + consumer + ")");
        }
        Set<MessageConsumer> set = this.consumers;
        synchronized (set) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer producer) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("addProducer(" + producer + ")");
        }
        Set<MessageProducer> set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer producer) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("removeProducer(" + producer + ")");
        }
        Set<MessageProducer> set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    Session getSessionInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        Session session = this.mc.getSession();
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getSessionInternal " + session + " for " + this);
        }
        return session;
    }

    XAResource getXAResourceInternal() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        try {
            XAResource xares = this.mc.getXAResource();
            if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
                ActiveMQRALogger.LOGGER.trace("getXAResourceInternal " + xares + " for " + this);
            }
            return xares;
        }
        catch (ResourceException e) {
            JMSException jmse = new JMSException("Unable to get XA Resource");
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    QueueSession getQueueSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof QueueSession)) {
            throw new InvalidDestinationException("Attempting to use QueueSession methods on: " + this);
        }
        return (QueueSession)s;
    }

    TopicSession getTopicSessionInternal() throws JMSException {
        Session s = this.getSessionInternal();
        if (!(s instanceof TopicSession)) {
            throw new InvalidDestinationException("Attempting to use TopicSession methods on: " + this);
        }
        return (TopicSession)s;
    }

    public void checkState() throws JMSException {
        if (this.mc != null) {
            this.mc.checkTransactionActive();
        }
    }
}

