/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.SshServer;

public final class ServerIdentity {
    public static final String ID_FILE_PREFIX = "ssh_host_";
    public static final String ID_FILE_SUFFIX = "_key";
    public static final String HOST_KEY_CONFIG_PROP = "HostKey";
    public static final String HOST_CERT_CONFIG_PROP = "HostCertificate";
    public static final Function<String, String> ID_GENERATOR = ServerIdentity::getIdentityFileName;

    private ServerIdentity() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <S extends SshServer> S setKeyPairProvider(S server, Properties props, boolean supportedOnly) throws IOException, GeneralSecurityException {
        KeyPairProvider provider = ServerIdentity.loadKeyPairProvider(props, supportedOnly, IoUtils.getLinkOptions((boolean)true));
        if (provider != null) {
            server.setKeyPairProvider(provider);
        }
        return server;
    }

    public static KeyPairProvider loadKeyPairProvider(Properties props, boolean supportedOnly, LinkOption ... options) throws IOException, GeneralSecurityException {
        Map<String, KeyPair> ids = ServerIdentity.loadIdentities(props, options);
        return IdentityUtils.createKeyPairProvider(ids, (boolean)supportedOnly);
    }

    public static Map<String, KeyPair> loadIdentities(Properties props, LinkOption ... options) throws IOException, GeneralSecurityException {
        Map<String, Path> ids = ServerIdentity.findIdentities(props, options);
        return IdentityUtils.loadIdentities(null, ids, null, (OpenOption[])IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static Map<String, Path> findIdentities(Properties props, LinkOption ... options) throws IOException {
        return ServerIdentity.getLocations(HOST_KEY_CONFIG_PROP, props, options);
    }

    public static Map<String, Path> findCertificates(Properties props, LinkOption ... options) throws IOException {
        return ServerIdentity.getLocations(HOST_CERT_CONFIG_PROP, props, options);
    }

    private static Map<String, Path> getLocations(String configPropKey, Properties props, LinkOption ... options) throws IOException {
        if (MapEntryUtils.isEmpty((Map)props)) {
            return Collections.emptyMap();
        }
        String keyList = props.getProperty(configPropKey);
        Object[] paths = GenericUtils.split((String)keyList, (char)',');
        if (GenericUtils.isEmpty((Object[])paths)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Path> ids = new TreeMap<String, Path>(String.CASE_INSENSITIVE_ORDER);
        for (Object p : paths) {
            Path prev;
            File file = new File((String)p);
            Path path = file.toPath();
            if (!Files.exists(path, options)) continue;
            Object type = ServerIdentity.getIdentityType(path.getFileName().toString());
            if (GenericUtils.isEmpty((CharSequence)type)) {
                type = p;
            }
            ValidateUtils.checkTrue(((prev = ids.put((String)type, path)) == null ? 1 : 0) != 0, (String)"Multiple mappings for type=%s", (Object)type);
        }
        return ids;
    }

    public static String getIdentityType(String name) {
        if (GenericUtils.isEmpty((CharSequence)name) || name.length() <= ID_FILE_PREFIX.length() + ID_FILE_SUFFIX.length() || !name.startsWith(ID_FILE_PREFIX) || !name.endsWith(ID_FILE_SUFFIX)) {
            return null;
        }
        return name.substring(ID_FILE_PREFIX.length(), name.length() - ID_FILE_SUFFIX.length());
    }

    public static String getIdentityFileName(NamedResource r) {
        return ServerIdentity.getIdentityFileName(r == null ? null : r.getName());
    }

    public static String getIdentityFileName(String type) {
        return IdentityUtils.getIdentityFileName((String)ID_FILE_PREFIX, (String)type, (String)ID_FILE_SUFFIX);
    }
}

