/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Optional;
import org.infinispan.commons.configuration.io.AbstractConfigurationWriter;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriterException;
import org.infinispan.commons.configuration.io.NamingStrategy;

public class XmlConfigurationWriter
extends AbstractConfigurationWriter {
    private String version = "1.0";
    private String encoding;
    private Optional<Boolean> standalone = Optional.empty();
    private boolean openTag;
    private boolean skipIndentClose;

    public XmlConfigurationWriter(Writer writer, boolean prettyPrint, boolean clearTextSecrets) {
        super(writer, 4, prettyPrint, clearTextSecrets, NamingStrategy.KEBAB_CASE);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Optional<Boolean> getStandalone() {
        return this.standalone;
    }

    public void setStandalone(Optional<Boolean> standalone) {
        this.standalone = standalone;
    }

    @Override
    public void writeStartDocument() {
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(this.version);
            if (this.encoding != null && !this.encoding.isEmpty()) {
                this.writer.write("\" encoding=\"");
                this.writer.write(this.encoding);
            }
            if (this.standalone.isPresent()) {
                this.writer.write("\" standalone=\"");
                if (this.standalone.get().booleanValue()) {
                    this.writer.write("yes");
                } else {
                    this.writer.write("no");
                }
            }
            this.writer.write("\"?>");
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    private void closeCurrentTag(boolean newline) throws IOException {
        if (this.openTag) {
            this.writer.write(">");
            if (newline) {
                this.nl();
            }
            this.openTag = false;
        }
    }

    @Override
    public void writeStartElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, false, true, true));
    }

    private void writeStartElement0(AbstractConfigurationWriter.Tag tag) {
        try {
            this.closeCurrentTag(true);
            this.tagStack.push(tag);
            this.tab();
            this.writer.write("<");
            this.writer.write(this.naming.convert(tag.getName()));
            this.openTag = true;
            this.indent();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String namespace, String name) {
        this.writeStartElement((String)(prefix == null ? "" : prefix + ":") + name);
    }

    @Override
    public void writeStartArrayElement(String name) {
        this.writeStartElement0(new AbstractConfigurationWriter.Tag(name, true, true, true));
    }

    @Override
    public void writeEndArrayElement() {
        this.writeEndElement();
    }

    @Override
    public void writeStartListElement(String name, boolean explicit) {
        if (explicit) {
            this.writeStartElement(name);
        } else {
            this.tagStack.push(new AbstractConfigurationWriter.Tag(name));
        }
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, String name, boolean explicit) {
        this.writeStartListElement((String)(prefix == null ? "" : prefix + ":") + name, explicit);
    }

    @Override
    public void writeEndListElement() {
        if (((AbstractConfigurationWriter.Tag)this.tagStack.peek()).isExplicitOuter()) {
            this.writeEndElement();
        } else {
            this.tagStack.pop();
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
        if (prefix == null || prefix.isEmpty()) {
            this.writeDefaultNamespace(namespace);
            return;
        }
        if (this.namespaces.containsKey(prefix)) {
            if (!((String)this.namespaces.get(prefix)).equals(namespace)) {
                throw new ConfigurationWriterException("Duplicate declaration of prefix '" + prefix + "' with different namespace");
            }
        } else {
            this.namespaces.put(prefix, namespace);
        }
        try {
            this.writer.write(" xmlns:");
            this.writer.write(prefix);
            this.writer.write("=\"");
            this.writer.write(namespace);
            this.writer.write("\"");
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespace) {
        if (!this.openTag) {
            throw new ConfigurationWriterException("Cannot set namespace without a started element");
        }
        try {
            this.writer.write(" xmlns=\"");
            this.writer.write(namespace);
            this.writer.write("\"");
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEndElement() {
        try {
            this.outdent();
            if (this.openTag) {
                this.writer.write("/>");
                this.nl();
                this.openTag = false;
                this.tagStack.pop();
            } else {
                if (this.skipIndentClose) {
                    this.skipIndentClose = false;
                } else {
                    this.tab();
                }
                this.writer.write("</");
                this.writer.write(((AbstractConfigurationWriter.Tag)this.tagStack.pop()).getName());
                this.writer.write(">");
                this.nl();
            }
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEndDocument() {
        try {
            this.closeCurrentTag(true);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, String value) {
        this.writeAttribute(name, value, true);
    }

    private void writeAttribute(String name, String value, boolean rename) {
        try {
            this.writer.write(32);
            this.writer.write(rename ? this.naming.convert(name) : name);
            this.writer.write("=\"");
            if (value != null) {
                this.writer.write(value.replaceAll("&", "&amp;"));
            }
            this.writer.write(34);
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeAttribute(String name, Iterable<String> values) {
        if (values.iterator().hasNext()) {
            this.writeAttribute(name, String.join((CharSequence)" ", values));
        }
    }

    @Override
    public void writeArrayElement(String outer, String inner, String attribute, Iterable<String> values) {
        boolean wrapped;
        Iterator<String> it = values.iterator();
        boolean bl = wrapped = !inner.equals(outer);
        if (it.hasNext()) {
            if (wrapped) {
                this.writeStartElement(outer);
            }
            while (it.hasNext()) {
                this.writeStartElement(inner);
                if (attribute == null) {
                    this.writeCharacters(it.next());
                } else {
                    this.writeAttribute(attribute, it.next());
                }
                this.writeEndElement();
            }
            if (wrapped) {
                this.writeEndElement();
            }
        }
    }

    @Override
    public void writeCharacters(String chars) {
        try {
            this.closeCurrentTag(false);
            this.writer.write(chars);
            this.skipIndentClose = true;
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeEmptyElement(String name) {
        try {
            this.closeCurrentTag(true);
            this.tab();
            this.writer.write("<");
            this.writer.write(this.naming.convert(name));
            this.writer.write("/>");
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public void writeStartMap(String name) {
        this.writeStartElement(name);
    }

    @Override
    public void writeMapItem(String element, String name, String key, String value) {
        this.writeStartElement(element);
        this.writeAttribute(name, key, false);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    @Override
    public void writeMapItem(String element, String name, String key) {
        this.writeStartElement(element);
        this.writeAttribute(name, key, false);
    }

    @Override
    public void writeEndMapItem() {
        this.writeEndElement();
    }

    @Override
    public void writeEndMap() {
        this.writeEndElement();
    }

    @Override
    public void writeComment(String comment) {
        try {
            this.closeCurrentTag(true);
            this.tab();
            this.writer.write("<!--");
            this.writer.write(comment);
            this.writer.write("-->");
            this.nl();
        }
        catch (IOException e) {
            throw new ConfigurationWriterException(e);
        }
    }

    @Override
    public boolean hasFeature(ConfigurationFormatFeature feature) {
        switch (feature) {
            case MIXED_ELEMENTS: 
            case BARE_COLLECTIONS: {
                return true;
            }
        }
        return false;
    }
}

