/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexRoot;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.metamodel.ElasticsearchIndexDescriptor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexModel;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexIdentifier;

public class ElasticsearchIndexModel
extends AbstractIndexModel<ElasticsearchIndexModel, ElasticsearchIndexRoot, ElasticsearchIndexField>
implements ElasticsearchIndexDescriptor,
ElasticsearchSearchIndexContext {
    private final IndexNames names;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final IndexSettings customIndexSettings;
    private final RootTypeMapping mapping;
    private final RootTypeMapping customMapping;

    public ElasticsearchIndexModel(IndexNames names, String mappedTypeName, IndexIdentifier identifier, ElasticsearchIndexRoot rootNode, Map<String, ElasticsearchIndexField> staticFields, List<AbstractElasticsearchIndexFieldTemplate<?>> fieldTemplates, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, IndexSettings customIndexSettings, RootTypeMapping mapping, RootTypeMapping customMapping) {
        super(names.hibernateSearchIndex(), mappedTypeName, identifier, (IndexCompositeNode)rootNode, staticFields, fieldTemplates);
        this.names = names;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.customIndexSettings = customIndexSettings;
        this.mapping = mapping;
        this.customMapping = customMapping;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[names=" + this.names + ", mapping=" + this.mapping + "]";
    }

    protected ElasticsearchIndexModel self() {
        return this;
    }

    @Override
    public IndexNames names() {
        return this.names;
    }

    @Override
    public int maxResultWindow() {
        return this.customIndexSettings == null || this.customIndexSettings.getMaxResultWindow() == null ? 10000 : this.customIndexSettings.getMaxResultWindow();
    }

    public void contributeLowLevelMetadata(LowLevelIndexMetadataBuilder builder) {
        builder.setAnalysisDefinitionRegistry(this.analysisDefinitionRegistry);
        builder.setCustomIndexSettings(this.customIndexSettings);
        builder.setMapping(this.mapping);
        builder.setCustomMapping(this.customMapping);
    }

    @Override
    public String readName() {
        return this.names.read().toString();
    }

    @Override
    public String writeName() {
        return this.names.write().toString();
    }
}

