/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;

public final class JsonElementTypes {
    public static final JsonElementType<JsonObject> OBJECT = new JsonElementType<JsonObject>(){

        @Override
        protected JsonObject nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonObject();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonObject value) {
            return value;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonObject();
        }

        public String toString() {
            return JsonObject.class.getSimpleName();
        }
    };
    public static final JsonElementType<JsonArray> ARRAY = new JsonElementType<JsonArray>(){

        @Override
        protected JsonArray nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonArray();
        }

        @Override
        protected JsonElement nullUnsafeToElement(JsonArray value) {
            return value;
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonArray();
        }

        public String toString() {
            return JsonArray.class.getSimpleName();
        }
    };
    public static final JsonElementType<String> STRING = new JsonElementType<String>(){

        @Override
        protected String nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : element.getAsJsonPrimitive().getAsString();
        }

        @Override
        protected JsonElement nullUnsafeToElement(String value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(String)";
        }
    };
    public static final JsonElementType<Boolean> BOOLEAN = new JsonElementType<Boolean>(){

        @Override
        protected Boolean nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : Boolean.valueOf(element.getAsJsonPrimitive().getAsBoolean());
        }

        @Override
        protected JsonElement nullUnsafeToElement(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Boolean)";
        }
    };
    public static final JsonElementType<Integer> INTEGER = new JsonNumberType<Integer>(){

        @Override
        protected Integer nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsInt();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Integer)";
        }
    };
    public static final JsonElementType<Long> LONG = new JsonNumberType<Long>(){

        @Override
        protected Long nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsLong();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Long)";
        }
    };
    public static final JsonElementType<Float> FLOAT = new JsonNumberType<Float>(){

        @Override
        protected Float nullUnsafeFromNumber(JsonPrimitive primitive) {
            return Float.valueOf(primitive.getAsFloat());
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Float)";
        }
    };
    public static final JsonElementType<Double> DOUBLE = new JsonNumberType<Double>(){

        @Override
        protected Double nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsDouble();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Double)";
        }
    };
    public static final JsonElementType<Byte> BYTE = new JsonNumberType<Byte>(){

        @Override
        protected Byte nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsByte();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Byte)";
        }
    };
    public static final JsonElementType<Short> SHORT = new JsonNumberType<Short>(){

        @Override
        protected Short nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsShort();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(Short)";
        }
    };
    public static final JsonElementType<BigDecimal> BIG_DECIMAL = new JsonNumberType<BigDecimal>(){

        @Override
        protected BigDecimal nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsBigDecimal();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(BigDecimal)";
        }
    };
    public static final JsonElementType<BigInteger> BIG_INTEGER = new JsonNumberType<BigInteger>(){

        @Override
        protected BigInteger nullUnsafeFromNumber(JsonPrimitive primitive) {
            return primitive.getAsBigInteger();
        }

        public String toString() {
            return JsonPrimitive.class.getSimpleName() + "(BigInteger)";
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive();
        }
    };

    private JsonElementTypes() {
    }

    private static abstract class JsonNumberType<T extends Number>
    extends JsonElementType<T> {
        private JsonNumberType() {
        }

        @Override
        protected T nullUnsafeFromElement(JsonElement element) {
            return element.isJsonNull() ? null : (T)this.nullUnsafeFromNumber(element.getAsJsonPrimitive());
        }

        protected abstract T nullUnsafeFromNumber(JsonPrimitive var1);

        @Override
        protected JsonElement nullUnsafeToElement(T value) {
            return new JsonPrimitive(value);
        }

        @Override
        protected boolean nullUnsafeIsInstance(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber();
        }
    }
}

