/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.search.projection.util.impl.SloppyMath;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchDistanceToFieldProjection<E, P>
extends AbstractElasticsearchProjection<E, P> {
    private static final JsonObjectAccessor SCRIPT_FIELDS_ACCESSOR = JsonAccessor.root().property("script_fields").asObject();
    private static final JsonObjectAccessor FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asObject();
    private static final JsonArrayAccessor SORT_ACCESSOR = JsonAccessor.root().property("sort").asArray();
    private static final ElasticsearchGeoPointFieldCodec CODEC = ElasticsearchGeoPointFieldCodec.INSTANCE;
    private static final ProjectionConverter<Double, Double> NO_OP_DOUBLE_CONVERTER = new ProjectionConverter(Double.class, (value, context) -> value);
    private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("\\D");
    private static final String DISTANCE_PROJECTION_SCRIPT = " if (doc.containsKey(params.fieldPath) && doc[params.fieldPath].size() != 0) { return doc[params.fieldPath].arcDistance(params.lat, params.lon); } else { return null; }";
    private final String absoluteFieldPath;
    private final boolean multiValued;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final ProjectionAccumulator<Double, Double, E, P> accumulator;
    private final String scriptFieldName;
    private final ElasticsearchFieldProjection<E, P, ?, Double> sourceProjection;

    private ElasticsearchDistanceToFieldProjection(Builder builder, boolean multiValued, ProjectionAccumulator<Double, Double, E, P> accumulator) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.multiValued = multiValued;
        this.center = builder.center;
        this.unit = builder.unit;
        this.accumulator = accumulator;
        if (!multiValued && builder.field.nestedPathHierarchy().isEmpty()) {
            this.scriptFieldName = ElasticsearchDistanceToFieldProjection.createScriptFieldName(this.absoluteFieldPath, this.center);
            this.sourceProjection = null;
        } else {
            this.scriptFieldName = null;
            this.sourceProjection = new ElasticsearchFieldProjection<E, P, Double, Double>(builder.scope, this.absoluteFieldPath, builder.field.absolutePathComponents(), this::computeDistanceWithUnit, NO_OP_DOUBLE_CONVERTER, accumulator);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append(", unit=").append(this.unit).append(", accumulator=").append(this.accumulator).append("]");
        return sb.toString();
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        if (this.multiValued || context.getDistanceSortIndex(this.absoluteFieldPath, this.center) == null) {
            if (this.scriptFieldName != null) {
                SCRIPT_FIELDS_ACCESSOR.property(this.scriptFieldName).asObject().property("script").asObject().set(requestBody, ElasticsearchDistanceToFieldProjection.createScript(this.absoluteFieldPath, this.center));
            } else {
                this.sourceProjection.request(requestBody, context);
            }
        }
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        Integer distanceSortIndex;
        Integer n = distanceSortIndex = this.multiValued ? null : context.getDistanceSortIndex(this.absoluteFieldPath, this.center);
        if (distanceSortIndex != null) {
            Object accumulated = this.accumulator.createInitial();
            accumulated = this.accumulator.accumulate(accumulated, (Object)this.extractDistanceFromSortKey(hit, distanceSortIndex));
            return (E)accumulated;
        }
        if (this.scriptFieldName != null) {
            Object accumulated = this.accumulator.createInitial();
            accumulated = this.accumulator.accumulate(accumulated, (Object)this.extractDistanceFromScriptField(hit));
            return (E)accumulated;
        }
        return this.sourceProjection.extract(projectionHitMapper, hit, context);
    }

    @Override
    public P transform(LoadingResult<?, ?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
        return (P)this.accumulator.finish(extractedData, NO_OP_DOUBLE_CONVERTER, convertContext);
    }

    private Double extractDistanceFromScriptField(JsonObject hit) {
        Optional projectedFieldElement = FIELDS_ACCESSOR.property(this.scriptFieldName).asArray().element(0).get(hit);
        if (!projectedFieldElement.isPresent() || ((JsonElement)projectedFieldElement.get()).isJsonNull()) {
            return null;
        }
        if (((JsonElement)projectedFieldElement.get()).isJsonPrimitive()) {
            return this.unit.fromMeters(Double.valueOf(((JsonElement)projectedFieldElement.get()).getAsDouble()));
        }
        JsonObject geoPoint = ((JsonElement)projectedFieldElement.get()).getAsJsonObject();
        return this.computeDistanceWithUnit((JsonElement)geoPoint);
    }

    private Double extractDistanceFromSortKey(JsonObject hit, int distanceSortIndex) {
        Optional sortKeyDistanceElement = SORT_ACCESSOR.element(distanceSortIndex).get(hit);
        if (!sortKeyDistanceElement.isPresent()) {
            return null;
        }
        if (!((JsonElement)sortKeyDistanceElement.get()).getAsJsonPrimitive().isNumber()) {
            return null;
        }
        double distanceInMeters = ((JsonElement)sortKeyDistanceElement.get()).getAsJsonPrimitive().getAsDouble();
        return this.unit.fromMeters(Double.valueOf(distanceInMeters));
    }

    private Double computeDistanceWithUnit(JsonElement geoPoint) {
        GeoPoint decoded = CODEC.decode(geoPoint);
        if (decoded == null) {
            return null;
        }
        double distanceInMeters = SloppyMath.haversinMeters(this.center.latitude(), this.center.longitude(), decoded.latitude(), decoded.longitude());
        return this.unit.fromMeters(Double.valueOf(distanceInMeters));
    }

    private static String createScriptFieldName(String absoluteFieldPath, GeoPoint center) {
        StringBuilder sb = new StringBuilder();
        sb.append("distance_").append(absoluteFieldPath).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.latitude())).replaceAll("_")).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.longitude())).replaceAll("_"));
        return sb.toString();
    }

    private static JsonObject createScript(String absoluteFieldPath, GeoPoint center) {
        JsonObject params = new JsonObject();
        params.addProperty("lat", (Number)center.latitude());
        params.addProperty("lon", (Number)center.longitude());
        params.addProperty("fieldPath", absoluteFieldPath);
        JsonObject scriptContent = new JsonObject();
        scriptContent.addProperty("lang", "painless");
        scriptContent.add("params", (JsonElement)params);
        scriptContent.addProperty("source", DISTANCE_PROJECTION_SCRIPT);
        return scriptContent;
    }

    public static class Builder
    extends AbstractElasticsearchProjection.AbstractBuilder<Double>
    implements DistanceToFieldProjectionBuilder {
        private final ElasticsearchSearchIndexValueFieldContext<GeoPoint> field;
        private GeoPoint center;
        private DistanceUnit unit = DistanceUnit.METERS;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            super(scope);
            this.field = field;
        }

        public void center(GeoPoint center) {
            this.center = center;
        }

        public void unit(DistanceUnit unit) {
            this.unit = unit;
        }

        public <P> SearchProjection<P> build(ProjectionAccumulator.Provider<Double, P> accumulatorProvider) {
            return new ElasticsearchDistanceToFieldProjection(this, !accumulatorProvider.isSingleValued(), accumulatorProvider.get());
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<DistanceToFieldProjectionBuilder, GeoPoint> {
        @Override
        public Builder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<GeoPoint> field) {
            field.nestedPathHierarchy();
            return new Builder(scope, field);
        }
    }
}

