/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbMap {
    @XmlAnyElement
    List<JAXBElement<Entry>> value = new ArrayList<JAXBElement<Entry>>();
    @XmlTransient
    private String entryName;
    @XmlTransient
    private String keyAttributeName;
    @XmlTransient
    private String namespace;

    public JaxbMap() {
    }

    public JaxbMap(String entryName, String keyAttributeName, String namespace) {
        this.entryName = entryName;
        this.namespace = namespace;
        this.keyAttributeName = keyAttributeName;
    }

    public void addEntry(String key, Object val) {
        Entry entry = new Entry(this.keyAttributeName, key, val);
        JAXBElement element = new JAXBElement(new QName(this.namespace, this.entryName), Entry.class, (Object)entry);
        this.value.add((JAXBElement<Entry>)element);
    }

    public List<JAXBElement<Entry>> getValue() {
        return this.value;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Entry {
        @XmlAnyElement
        Object value;
        @XmlAnyAttribute
        Map<QName, Object> attribute = new HashMap<QName, Object>();
        @XmlTransient
        private String key;
        @XmlTransient
        private String keyAttributeName;

        public Entry() {
        }

        public Entry(String keyAttributeName, String key, Object value) {
            this.value = value;
            this.keyAttributeName = keyAttributeName;
            this.setKey(key);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getKey() {
            if (this.key != null) {
                return this.key;
            }
            this.key = (String)this.attribute.values().iterator().next();
            return this.key;
        }

        public void setKey(String keyValue) {
            this.key = keyValue;
            this.attribute.clear();
            QName name = new QName(this.keyAttributeName);
            this.attribute.put(name, keyValue);
        }
    }
}

