/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedFunction<T, U>
extends AbstractScriptEvaluator
implements Function<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedFunction.class);
    @Nullable
    private Class<T> inputTypeClass;

    protected ScriptedFunction(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted Function from " + extraInfo + ":");
    }

    protected ScriptedFunction(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous Function:");
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    public U apply(@Nullable T input) {
        if (null != this.getInputType() && null != input && !this.getInputType().isInstance(input)) {
            this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), input.getClass(), this.getInputType()});
            return (U)this.getReturnOnError();
        }
        return (U)this.evaluate(input);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input", input[0], 100);
    }

    public static <T, U> ScriptedFunction<T, U> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedFunction<T, U> scriptedFunction = new ScriptedFunction<T, U>(script, resource.getDescription());
            return scriptedFunction;
        }
    }

    public static <T, U> ScriptedFunction<T, U> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedFunction.resourceScript("JavaScript", resource);
    }

    public static <T, U> ScriptedFunction<T, U> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedFunction<T, U>(script, "Inline");
    }

    public static <T, U> ScriptedFunction<T, U> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedFunction<T, U>(script, "Inline");
    }
}

