/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Collection;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.NamingService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.jms.DestinationConfiguration;
import org.wildfly.extension.messaging.activemq.jms.ExternalPooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalJMSTopicService
implements Service<Topic> {
    static final String JMS_TOPIC_PREFIX = "jms.topic.";
    private final InjectedValue<NamingStore> namingStoreInjector = new InjectedValue();
    private final InjectedValue<ExternalPooledConnectionFactoryService> pcfInjector = new InjectedValue();
    private Topic topic;
    private final String topicName;
    private final DestinationConfiguration config;
    private ClientSessionFactory sessionFactory;

    private ExternalJMSTopicService(String name, boolean enabledAMQ1Prefix) {
        this.topicName = enabledAMQ1Prefix ? JMS_TOPIC_PREFIX + name : name;
        this.config = null;
    }

    private ExternalJMSTopicService(DestinationConfiguration config, boolean enabledAMQ1Prefix) {
        this.topicName = enabledAMQ1Prefix ? JMS_TOPIC_PREFIX + config.getName() : config.getName();
        this.config = config;
    }

    public synchronized void start(StartContext context) throws StartException {
        NamingStore namingStore = (NamingStore)this.namingStoreInjector.getOptionalValue();
        if (namingStore != null) {
            final Queue managementQueue = this.config.getManagementQueue();
            NamingContext storeBaseContext = new NamingContext(namingStore, null);
            try {
                ConnectionFactory cf = (ConnectionFactory)storeBaseContext.lookup(((ExternalPooledConnectionFactoryService)this.pcfInjector.getValue()).getBindInfo().getAbsoluteJndiName());
                if (cf instanceof ActiveMQRAConnectionFactory) {
                    ActiveMQRAConnectionFactory raCf = (ActiveMQRAConnectionFactory)cf;
                    ServerLocator locator = raCf.getDefaultFactory().getServerLocator();
                    final ClientProtocolManagerFactory protocolManagerFactory = locator.getProtocolManagerFactory();
                    this.sessionFactory = locator.createSessionFactory();
                    ClusterTopologyListener listener = new ClusterTopologyListener(){

                        public void nodeUP(TopologyMember member, boolean last) {
                            ActiveMQConnectionFactory factory;
                            try {
                                factory = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{member.getLive()});
                                try {
                                    factory.getServerLocator().setProtocolManagerFactory(protocolManagerFactory);
                                    MessagingLogger.ROOT_LOGGER.infof("Creating topic %s on node UP %s - %s", (Object)ExternalJMSTopicService.this.topicName, (Object)member.getNodeId(), (Object)member.getLive().toString());
                                    ExternalJMSTopicService.this.config.createTopic((ConnectionFactory)factory, managementQueue, ExternalJMSTopicService.this.topicName);
                                }
                                finally {
                                    factory.close();
                                }
                            }
                            catch (JMSException | StartException ex) {
                                MessagingLogger.ROOT_LOGGER.errorf(ex, "Creating topic %s on node UP %s failed", (Object)ExternalJMSTopicService.this.topicName, (Object)member.getLive().toString());
                                throw new RuntimeException(ex);
                            }
                            if (member.getBackup() != null) {
                                try {
                                    factory = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{member.getBackup()});
                                    try {
                                        factory.getServerLocator().setProtocolManagerFactory(protocolManagerFactory);
                                        MessagingLogger.ROOT_LOGGER.infof("Creating topic %s on backup node UP %s - %s", (Object)ExternalJMSTopicService.this.topicName, (Object)member.getNodeId(), (Object)member.getBackup().toString());
                                        ExternalJMSTopicService.this.config.createTopic((ConnectionFactory)factory, managementQueue, ExternalJMSTopicService.this.topicName);
                                    }
                                    finally {
                                        factory.close();
                                    }
                                }
                                catch (JMSException | StartException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        }

                        public void nodeDown(long eventUID, String nodeID) {
                        }
                    };
                    locator.addClusterTopologyListener(listener);
                    Collection members = locator.getTopology().getMembers();
                    if (members == null || members.isEmpty()) {
                        this.config.createTopic(cf, managementQueue, this.topicName);
                    }
                } else {
                    this.config.createTopic(cf, managementQueue, this.topicName);
                }
            }
            catch (Exception ex) {
                MessagingLogger.ROOT_LOGGER.errorf((Throwable)ex, "Error starting the external queue service %s", (Object)ex.getMessage());
                throw new StartException((Throwable)ex);
            }
            finally {
                try {
                    storeBaseContext.close();
                }
                catch (NamingException ex) {
                    MessagingLogger.ROOT_LOGGER.tracef((Throwable)ex, "Error closing the naming context %s", (Object)ex.getMessage());
                }
            }
        }
        this.topic = ActiveMQDestination.createTopic((String)this.topicName);
    }

    public synchronized void stop(StopContext context) {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }

    public Topic getValue() throws IllegalStateException {
        return this.topic;
    }

    public static ExternalJMSTopicService installService(String name, ServiceName serviceName, ServiceTarget serviceTarget, boolean enabledAMQ1Prefix) {
        ExternalJMSTopicService service = new ExternalJMSTopicService(name, enabledAMQ1Prefix);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service);
        serviceBuilder.install();
        return service;
    }

    public static ExternalJMSTopicService installRuntimeTopicService(DestinationConfiguration config, ServiceTarget serviceTarget, ServiceName pcf, boolean enabledAMQ1Prefix) {
        ExternalJMSTopicService service = new ExternalJMSTopicService(config, enabledAMQ1Prefix);
        ServiceBuilder serviceBuilder = serviceTarget.addService(config.getDestinationServiceName(), (Service)service);
        serviceBuilder.addDependency(NamingService.SERVICE_NAME, NamingStore.class, service.namingStoreInjector);
        serviceBuilder.addDependency(pcf, ExternalPooledConnectionFactoryService.class, service.pcfInjector);
        serviceBuilder.requires(ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{config.getResourceAdapter()}));
        serviceBuilder.install();
        return service;
    }
}

