/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.util.Optional;
import java.util.function.Function;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

abstract class BaseFunction<K extends CounterKey, R>
implements Function<EntryView.ReadWriteEntryView<K, CounterValue>, R> {
    BaseFunction() {
    }

    @Override
    public final R apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView) {
        Optional value = entryView.find();
        if (!value.isPresent()) {
            return null;
        }
        Optional metadata = entryView.findMetaParam(CounterConfigurationMetaParam.class);
        if (!metadata.isPresent()) {
            throw this.getLog().metadataIsMissing(((CounterKey)entryView.key()).getCounterName());
        }
        return this.apply(entryView, (CounterConfigurationMetaParam)metadata.get());
    }

    abstract R apply(EntryView.ReadWriteEntryView<K, CounterValue> var1, CounterConfigurationMetaParam var2);

    protected abstract Log getLog();
}

