/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.deployment;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.ServletDelegate;
import org.jboss.wsf.spi.deployment.ServletDelegateFactory;

public class WSFServlet
extends HttpServlet {
    private static final long serialVersionUID = -1958443536378468262L;
    public static final String STACK_SERVLET_DELEGATE_CLASS = "org.jboss.wsf.spi.deployment.stackServletDelegateClass";
    private volatile ServletDelegate delegate = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.delegate = this.getDelegate(servletConfig);
        if (this.delegate != null) {
            this.delegate.init(servletConfig);
        }
    }

    protected ServletDelegate getDelegate(ServletConfig servletConfig) {
        ClassLoaderProvider clProvider = ClassLoaderProvider.getDefaultProvider();
        ClassLoader cl = clProvider.getWebServiceSubsystemClassLoader();
        ServiceLoader<ServletDelegateFactory> sl = ServiceLoader.load(ServletDelegateFactory.class, cl);
        ServletDelegateFactory factory = sl.iterator().next();
        return factory.newServletDelegate(servletConfig.getInitParameter(STACK_SERVLET_DELEGATE_CLASS));
    }

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.doPost(request, response, this.getServletContext());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.doGet(request, response, this.getServletContext());
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.doPut(request, response, this.getServletContext());
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.doDelete(request, response, this.getServletContext());
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.doHead(request, response, this.getServletContext());
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.delegate != null) {
            this.delegate.service(request, response, this.getServletContext());
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

