/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.impl;

import jakarta.transaction.Transaction;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.IncorrectListenerException;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.notifications.impl.SecurityActions;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.NONE)
public abstract class AbstractListenerImpl<T, L extends ListenerInvocation<T>> {
    @Inject
    @ComponentName(value="org.infinispan.executors.notification")
    protected Executor asyncProcessor;
    @Inject
    BlockingManager blockingManager;
    protected final Map<Class<? extends Annotation>, List<L>> listenersMap = new HashMap<Class<? extends Annotation>, List<L>>(16, 0.99f);

    @Stop(priority=99)
    public void stop() {
        for (List<L> list : this.listenersMap.values()) {
            if (list == null) continue;
            list.clear();
        }
    }

    protected CompletionStage<Void> resumeOnCPU(CompletionStage<Void> stage, Object traceId) {
        return this.blockingManager.continueOnNonBlockingThread(stage, traceId);
    }

    protected abstract Log getLog();

    protected abstract Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener var1);

    public boolean hasListener(Class<? extends Annotation> annotationClass) {
        List<L> annotations = this.listenersMap.get(annotationClass);
        return annotations != null && !annotations.isEmpty();
    }

    protected List<L> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        List<L> list = this.listenersMap.get(annotation);
        if (list == null) {
            throw new CacheException("Unknown listener annotation: " + annotation);
        }
        return list;
    }

    public abstract CompletionStage<Void> removeListenerAsync(Object var1);

    protected static AggregateCompletionStage<Void> composeStageIfNeeded(AggregateCompletionStage<Void> aggregateCompletionStage, CompletionStage<Void> stage) {
        if (stage != null && !CompletionStages.isCompletedSuccessfully(stage)) {
            if (aggregateCompletionStage == null) {
                aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            }
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage;
    }

    protected void removeListenerFromMaps(Object listener) {
        for (Class<Annotation> annotation : this.getAllowedMethodAnnotations(AbstractListenerImpl.testListenerClassValidity(listener.getClass())).keySet()) {
            this.removeListenerInvocation(annotation, listener);
        }
    }

    protected Set<L> removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        List<L> l = this.getListenerCollectionForAnnotation(annotation);
        HashSet<ListenerInvocation> markedForRemoval = new HashSet<ListenerInvocation>(4);
        for (ListenerInvocation li : l) {
            if (!listener.equals(li.getTarget())) continue;
            markedForRemoval.add(li);
        }
        l.removeAll(markedForRemoval);
        return markedForRemoval;
    }

    public Set<Object> getListeners() {
        HashSet<Object> result = new HashSet<Object>(this.listenersMap.size());
        for (List<L> list : this.listenersMap.values()) {
            for (ListenerInvocation li : list) {
                result.add(li.getTarget());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected boolean validateAndAddListenerInvocations(Object listener, AbstractInvocationBuilder builder) {
        Listener l = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        builder.setTarget(listener);
        builder.setSubject(Security.getSubject());
        builder.setSync(l.sync());
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations(l);
        for (Method m : listener.getClass().getMethods()) {
            if (m.isSynthetic() && m.isBridge()) continue;
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<Annotation> annotationClass = annotationEntry.getKey();
                if (!m.isAnnotationPresent(annotationClass)) continue;
                Class<?> eventClass = annotationEntry.getValue();
                AbstractListenerImpl.testListenerMethodValidity(m, eventClass, annotationClass.getName());
                if (System.getSecurityManager() == null) {
                    m.setAccessible(true);
                } else {
                    AccessController.doPrivileged(() -> {
                        m.setAccessible(true);
                        return null;
                    });
                }
                builder.setMethod(m);
                builder.setAnnotation(annotationClass);
                Object invocation = builder.build();
                this.getLog().tracef("Add listener invocation %s for %s", invocation, annotationClass);
                this.getListenerCollectionForAnnotation(annotationClass).add(invocation);
                foundMethods = true;
            }
        }
        if (!foundMethods) {
            this.getLog().noAnnotateMethodsFoundInListener(listener.getClass());
        }
        return foundMethods;
    }

    protected boolean validateAndAddFilterListenerInvocations(Object listener, AbstractInvocationBuilder builder, Set<Class<? extends Annotation>> filterAnnotations) {
        Listener l = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        boolean foundMethods = false;
        builder.setTarget(listener);
        builder.setSubject(Security.getSubject());
        builder.setSync(l.sync());
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations(l);
        for (Method m : listener.getClass().getMethods()) {
            if (m.isSynthetic() && m.isBridge()) continue;
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<Annotation> annotationClass = annotationEntry.getKey();
                if (!m.isAnnotationPresent(annotationClass) || !this.canApply(filterAnnotations, annotationClass)) continue;
                Class<?> eventClass = annotationEntry.getValue();
                AbstractListenerImpl.testListenerMethodValidity(m, eventClass, annotationClass.getName());
                if (System.getSecurityManager() == null) {
                    m.setAccessible(true);
                } else {
                    AccessController.doPrivileged(() -> {
                        m.setAccessible(true);
                        return null;
                    });
                }
                builder.setMethod(m);
                builder.setAnnotation(annotationClass);
                Object invocation = builder.build();
                this.getLog().tracef("Add listener invocation %s for %s", invocation, annotationClass);
                this.getListenerCollectionForAnnotation(annotationClass).add(invocation);
                foundMethods = true;
            }
        }
        if (!foundMethods) {
            this.getLog().noAnnotateMethodsFoundInListener(listener.getClass());
        }
        return foundMethods;
    }

    public boolean canApply(Set<Class<? extends Annotation>> filterAnnotations, Class<? extends Annotation> annotationClass) {
        return annotationClass != CacheEntryCreated.class && annotationClass != CacheEntryModified.class && annotationClass != CacheEntryRemoved.class && annotationClass != CacheEntryExpired.class || filterAnnotations.contains(annotationClass);
    }

    protected Set<Class<? extends Annotation>> findListenerCallbacks(Object listener) {
        HashSet<Class<? extends Annotation>> listenerInterests = new HashSet<Class<? extends Annotation>>();
        Listener l = AbstractListenerImpl.testListenerClassValidity(listener.getClass());
        Map<Class<Annotation>, Class<?>> allowedListeners = this.getAllowedMethodAnnotations(l);
        for (Method m : listener.getClass().getMethods()) {
            if (m.isSynthetic() && m.isBridge()) continue;
            for (Map.Entry<Class<Annotation>, Class<?>> annotationEntry : allowedListeners.entrySet()) {
                Class<Annotation> annotationClass = annotationEntry.getKey();
                if (!m.isAnnotationPresent(annotationClass)) continue;
                Class<?> eventClass = annotationEntry.getValue();
                AbstractListenerImpl.testListenerMethodValidity(m, eventClass, annotationClass.getName());
                if (System.getSecurityManager() == null) {
                    m.setAccessible(true);
                } else {
                    AccessController.doPrivileged(() -> {
                        m.setAccessible(true);
                        return null;
                    });
                }
                listenerInterests.add(annotationClass);
            }
        }
        return listenerInterests;
    }

    protected static Listener testListenerClassValidity(Class<?> listenerClass) {
        Listener l = (Listener)ReflectionUtil.getAnnotation(listenerClass, Listener.class);
        if (l == null) {
            throw new IncorrectListenerException(String.format("Cache listener class %s must be annotated with org.infinispan.notifications.Listener", listenerClass.getName()));
        }
        return l;
    }

    protected static void testListenerMethodValidity(Method m, Class<?> allowedParameter, String annotationName) {
        if (m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(allowedParameter)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " must accept exactly one parameter, of assignable from type " + allowedParameter.getName());
        }
        Class<?> returnType = m.getReturnType();
        if (!returnType.equals(Void.TYPE) && !CompletionStage.class.isAssignableFrom(returnType)) {
            throw new IncorrectListenerException("Methods annotated with " + annotationName + " should have a return type of void or CompletionStage.");
        }
    }

    protected CompletionStage<Void> invokeListeners(T event, Collection<L> listeners) {
        AggregateCompletionStage<Void> aggregateCompletionStage = null;
        for (ListenerInvocation listener : listeners) {
            aggregateCompletionStage = AbstractListenerImpl.composeStageIfNeeded(aggregateCompletionStage, this.invokeListener(listener, event));
        }
        if (aggregateCompletionStage != null) {
            return this.resumeOnCPU(aggregateCompletionStage.freeze(), event);
        }
        return CompletableFutures.completedNull();
    }

    private CompletionStage<Void> invokeListener(L listener, T e) {
        try {
            CompletionStage<Void> stage = listener.invoke(e);
            if (stage != null && !CompletionStages.isCompletedSuccessfully(stage)) {
                return stage.exceptionally(t -> {
                    this.handleException((Throwable)t);
                    return null;
                });
            }
        }
        catch (Exception x) {
            this.handleException(x);
        }
        return null;
    }

    protected void handleException(Throwable t) {
    }

    protected abstract Transaction suspendIfNeeded();

    protected abstract void resumeIfNeeded(Transaction var1);

    private Throwable getRealException(Throwable re) {
        if (re.getCause() == null) {
            return re;
        }
        Throwable cause = re.getCause();
        if (cause instanceof RuntimeException || cause instanceof Error) {
            return this.getRealException(cause);
        }
        return re;
    }

    protected abstract class AbstractInvocationBuilder {
        protected Object target;
        protected Method method;
        protected Class<? extends Annotation> annotation;
        protected boolean sync;
        protected ClassLoader classLoader;
        protected Subject subject;

        protected AbstractInvocationBuilder() {
        }

        public Object getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        public AbstractInvocationBuilder setAnnotation(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
            return this;
        }

        public boolean isSync() {
            return this.sync;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public AbstractInvocationBuilder setTarget(Object target) {
            this.target = target;
            return this;
        }

        public AbstractInvocationBuilder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public AbstractInvocationBuilder setSync(boolean sync) {
            this.sync = sync;
            return this;
        }

        public AbstractInvocationBuilder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public AbstractInvocationBuilder setSubject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public abstract L build();
    }

    protected class ListenerInvocationImpl<A>
    implements ListenerInvocation<A> {
        final Object target;
        final Method method;
        final boolean sync;
        final WeakReference<ClassLoader> classLoader;
        final Subject subject;

        public ListenerInvocationImpl(Object target, Method method, boolean sync, ClassLoader classLoader, Subject subject) {
            this.target = target;
            this.method = method;
            this.sync = sync;
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            this.subject = subject;
        }

        @Override
        public CompletionStage<Void> invoke(A event) {
            Supplier<Object> r = () -> {
                ClassLoader contextClassLoader = null;
                Transaction transaction = AbstractListenerImpl.this.suspendIfNeeded();
                if (this.classLoader.get() != null) {
                    contextClassLoader = SecurityActions.setContextClassLoader((ClassLoader)this.classLoader.get());
                }
                try {
                    Object result;
                    if (this.subject != null) {
                        try {
                            result = Security.doAs(this.subject, () -> {
                                AbstractListenerImpl.this.getLog().tracef("Invoking listener: %s passing event %s using subject", this.target, event);
                                return this.method.invoke(this.target, event);
                            });
                        }
                        catch (PrivilegedActionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof InvocationTargetException) {
                                throw (InvocationTargetException)cause;
                            }
                            if (cause instanceof IllegalAccessException) {
                                throw (IllegalAccessException)cause;
                            }
                            throw new InvocationTargetException(cause);
                        }
                    } else {
                        AbstractListenerImpl.this.getLog().tracef("Invoking listener: %s passing event %s", this.target, event);
                        result = this.method.invoke(this.target, event);
                    }
                    Object e = result;
                    return e;
                }
                catch (InvocationTargetException exception) {
                    Throwable cause = AbstractListenerImpl.this.getRealException(exception);
                    if (this.sync) {
                        throw AbstractListenerImpl.this.getLog().exceptionInvokingListener(cause.getClass().getName(), this.method, this.target, cause);
                    }
                    AbstractListenerImpl.this.getLog().unableToInvokeListenerMethod(this.method, this.target, cause);
                }
                catch (IllegalAccessException exception) {
                    AbstractListenerImpl.this.getLog().unableToInvokeListenerMethodAndRemoveListener(this.method, this.target, exception);
                    AbstractListenerImpl.this.removeListenerAsync(this.target);
                }
                finally {
                    if (this.classLoader.get() != null) {
                        SecurityActions.setContextClassLoader(contextClassLoader);
                    }
                    AbstractListenerImpl.this.resumeIfNeeded(transaction);
                }
                return null;
            };
            if (this.sync) {
                Object result = r.get();
                if (result instanceof CompletionStage) {
                    CompletionStage<Void> stage = (CompletionStage<Void>)result;
                    if (AbstractListenerImpl.this.getLog().isTraceEnabled()) {
                        stage = stage.whenComplete((v, t) -> AbstractListenerImpl.this.getLog().tracef("Listener %s has completed event %s", this.target, event));
                    }
                    return stage;
                }
            } else {
                AbstractListenerImpl.this.asyncProcessor.execute(r::get);
                AbstractListenerImpl.this.getLog().tracef("Listener %s has completed event %s", this.target, event);
            }
            return CompletableFutures.completedNull();
        }

        @Override
        public Object getTarget() {
            return this.target;
        }
    }
}

