/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.util.logging.Log;

public abstract class AbstractContainerStats
extends AbstractClusterStats {
    protected static final String MEMORY_AVAILABLE = "memoryAvailable";
    protected static final String MEMORY_MAX = "memoryMax";
    protected static final String MEMORY_TOTAL = "memoryTotal";
    protected static final String MEMORY_USED = "memoryUsed";
    private static final String[] LONG_ATTRIBUTES = new String[]{"memoryAvailable", "memoryMax", "memoryTotal", "memoryUsed"};

    AbstractContainerStats(Log log) {
        super(log);
    }

    protected static Map<String, Number> getLocalStatMaps() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        long available = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        map.put(MEMORY_AVAILABLE, available);
        map.put(MEMORY_MAX, max);
        map.put(MEMORY_TOTAL, total);
        map.put(MEMORY_USED, total - available);
        return map;
    }

    protected abstract List<Map<String, Number>> statistics() throws Exception;

    @Override
    void updateStats() throws Exception {
        List<Map<String, Number>> memoryMap = this.statistics();
        for (String attr : LONG_ATTRIBUTES) {
            this.putLongAttributes(memoryMap, attr);
        }
    }
}

