/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.stats.impl.AbstractContainerStats;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="LocalContainerStats", description="General statistic of local container.")
public class LocalContainerStatsImpl
extends AbstractContainerStats
implements ClusterContainerStats {
    public static final String LOCAL_CONTAINER_STATS = "LocalContainerStats";
    private static final Log log = LogFactory.getLog(LocalContainerStatsImpl.class);

    LocalContainerStatsImpl() {
        super(log);
    }

    @Inject
    public void init(GlobalConfiguration configuration) {
        this.statisticsEnabled = configuration.statistics();
    }

    @Override
    protected List<Map<String, Number>> statistics() throws Exception {
        return Collections.singletonList(LocalContainerStatsImpl.getLocalStatMaps());
    }

    @Override
    @ManagedAttribute(description="The maximum amount of free memory in bytes in local JVM", displayName="Local available memory.")
    public long getMemoryAvailable() {
        return this.getStatAsLong("memoryAvailable");
    }

    @Override
    @ManagedAttribute(description="The maximum amount of memory in local JVM will attempt to utilise in bytes", displayName="Local JVM max memory")
    public long getMemoryMax() {
        return this.getStatAsLong("memoryMax");
    }

    @Override
    @ManagedAttribute(description="The total amount of memory in the local JVM in bytes", displayName="Local total memory")
    public long getMemoryTotal() {
        return this.getStatAsLong("memoryTotal");
    }

    @Override
    @ManagedAttribute(description="The amount of memory used by the local JVM in bytes", displayName="Local memory utilisation")
    public long getMemoryUsed() {
        return this.getStatAsLong("memoryUsed");
    }
}

