/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;

public class XSiteStateTransferCancelSendCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 105;
    private String siteName;

    public XSiteStateTransferCancelSendCommand() {
        super(null);
    }

    public XSiteStateTransferCancelSendCommand(ByteString cacheName) {
        this(cacheName, null);
    }

    public XSiteStateTransferCancelSendCommand(ByteString cacheName, String siteName) {
        super(cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        this.invokeLocal(registry.getXSiteStateTransferManager().running().getStateProvider());
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 105;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.siteName);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = input.readUTF();
    }

    @Override
    public String toString() {
        return "XSiteStateTransferCancelSendCommand{siteName='" + this.siteName + "', cacheName=" + this.cacheName + "}";
    }

    public void invokeLocal(XSiteStateProvider provider) {
        provider.cancelStateTransfer(this.siteName);
    }
}

