/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractResourceBundle
extends ResourceBundle {
    public static final String LOCALE = "com.sun.xml.fastinfoset.locale";

    public String getString(String key, Object[] args) {
        String pattern = this.getBundle().getString(key);
        return MessageFormat.format(pattern, args);
    }

    public static Locale parseLocale(String localeString) {
        Locale locale = null;
        if (localeString == null) {
            locale = Locale.getDefault();
        } else {
            try {
                String[] args = localeString.split("_");
                switch (args.length) {
                    case 1: {
                        locale = new Locale(args[0]);
                        break;
                    }
                    case 2: {
                        locale = new Locale(args[0], args[1]);
                        break;
                    }
                    case 3: {
                        locale = new Locale(args[0], args[1], args[2]);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public abstract ResourceBundle getBundle();

    @Override
    protected Object handleGetObject(String key) {
        return this.getBundle().getObject(key);
    }

    @Override
    public final Enumeration<String> getKeys() {
        return this.getBundle().getKeys();
    }
}

