/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.ArrayDeque;

interface ContextHandle {
    public Handle setup();

    public static class ChainedContextHandle
    implements ContextHandle {
        private final ContextHandle[] contextHandles;

        public ChainedContextHandle(ContextHandle ... contextHandles) {
            this.contextHandles = contextHandles;
        }

        @Override
        public Handle setup() {
            final ArrayDeque<Handle> handles = new ArrayDeque<Handle>();
            try {
                for (ContextHandle contextHandle : this.contextHandles) {
                    handles.addFirst(contextHandle.setup());
                }
                return new Handle(){

                    @Override
                    public void tearDown() {
                        Exception rethrow = null;
                        for (Handle handle : handles) {
                            try {
                                handle.tearDown();
                            }
                            catch (Exception e) {
                                if (rethrow != null) continue;
                                rethrow = e;
                            }
                        }
                        if (rethrow != null) {
                            throw new RuntimeException(rethrow);
                        }
                    }
                };
            }
            catch (Exception e) {
                for (Handle handle : handles) {
                    try {
                        handle.tearDown();
                    }
                    catch (Exception exception) {}
                }
                throw e;
            }
        }
    }

    public static interface Handle {
        public void tearDown();
    }
}

