/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class BeanReferences {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private BeanReferences() {
    }

    public static <T> BeanReference<T> parse(Class<T> expectedType, String value) {
        String name;
        BeanRetrieval retrieval;
        Contracts.assertNotNull(expectedType, (String)"expectedType");
        Contracts.assertNotNullNorEmpty((String)value, (String)"value");
        int colonIndex = value.indexOf(58);
        if (colonIndex < 0) {
            retrieval = BeanRetrieval.ANY;
            name = value;
        } else {
            String retrievalAsString = value.substring(0, colonIndex);
            try {
                retrieval = BeanRetrieval.valueOf(retrievalAsString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw log.invalidBeanRetrieval(value, retrievalAsString + ':', Arrays.stream(BeanRetrieval.values()).map(v -> v.name().toLowerCase(Locale.ROOT) + ':').collect(Collectors.toList()), e);
            }
            name = value.substring(colonIndex + 1);
        }
        return BeanReference.of(expectedType, name, retrieval);
    }
}

