/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.dsl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.CompositeProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.DistanceToFieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.DocumentReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.EntityProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.EntityReferenceProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.FieldProjectionValueStep;
import org.hibernate.search.engine.search.projection.dsl.IdProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.ScoreProjectionOptionsStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactoryExtensionIfSupportedStep;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.function.TriFunction;

public interface SearchProjectionFactory<R, E> {
    public DocumentReferenceProjectionOptionsStep<?> documentReference();

    public EntityReferenceProjectionOptionsStep<?, R> entityReference();

    default public IdProjectionOptionsStep<?, Object> id() {
        return this.id(Object.class);
    }

    public <I> IdProjectionOptionsStep<?, I> id(Class<I> var1);

    public EntityProjectionOptionsStep<?, E> entity();

    default public <T> FieldProjectionValueStep<?, T> field(String fieldPath, Class<T> type) {
        return this.field(fieldPath, type, ValueConvert.YES);
    }

    public <T> FieldProjectionValueStep<?, T> field(String var1, Class<T> var2, ValueConvert var3);

    default public FieldProjectionValueStep<?, Object> field(String fieldPath) {
        return this.field(fieldPath, ValueConvert.YES);
    }

    public FieldProjectionValueStep<?, Object> field(String var1, ValueConvert var2);

    public ScoreProjectionOptionsStep<?> score();

    public DistanceToFieldProjectionValueStep<?, Double> distance(String var1, GeoPoint var2);

    default public CompositeProjectionOptionsStep<?, List<?>> composite(SearchProjection<?> ... projections) {
        return this.composite(Function.identity(), projections);
    }

    default public CompositeProjectionOptionsStep<?, List<?>> composite(ProjectionFinalStep<?> ... dslFinalSteps) {
        return this.composite(Function.identity(), dslFinalSteps);
    }

    public <T> CompositeProjectionOptionsStep<?, T> composite(Function<List<?>, T> var1, SearchProjection<?> ... var2);

    default public <T> CompositeProjectionOptionsStep<?, T> composite(Function<List<?>, T> transformer, ProjectionFinalStep<?> ... dslFinalSteps) {
        SearchProjection[] projections = new SearchProjection[dslFinalSteps.length];
        for (int i = 0; i < dslFinalSteps.length; ++i) {
            projections[i] = dslFinalSteps[i].toProjection();
        }
        return this.composite(transformer, projections);
    }

    public <P, T> CompositeProjectionOptionsStep<?, T> composite(Function<P, T> var1, SearchProjection<P> var2);

    default public <P, T> CompositeProjectionOptionsStep<?, T> composite(Function<P, T> transformer, ProjectionFinalStep<P> dslFinalStep) {
        return this.composite(transformer, dslFinalStep.toProjection());
    }

    public <P1, P2, T> CompositeProjectionOptionsStep<?, T> composite(BiFunction<P1, P2, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3);

    default public <P1, P2, T> CompositeProjectionOptionsStep<?, T> composite(BiFunction<P1, P2, T> transformer, ProjectionFinalStep<P1> dslFinalStep1, ProjectionFinalStep<P2> dslFinalStep2) {
        return this.composite(transformer, dslFinalStep1.toProjection(), dslFinalStep2.toProjection());
    }

    public <P1, P2, P3, T> CompositeProjectionOptionsStep<?, T> composite(TriFunction<P1, P2, P3, T> var1, SearchProjection<P1> var2, SearchProjection<P2> var3, SearchProjection<P3> var4);

    default public <P1, P2, P3, T> CompositeProjectionOptionsStep<?, T> composite(TriFunction<P1, P2, P3, T> transformer, ProjectionFinalStep<P1> dslFinalStep1, ProjectionFinalStep<P2> dslFinalStep2, ProjectionFinalStep<P3> dslFinalStep3) {
        return this.composite(transformer, dslFinalStep1.toProjection(), dslFinalStep2.toProjection(), dslFinalStep3.toProjection());
    }

    public <T> T extension(SearchProjectionFactoryExtension<T, R, E> var1);

    public <T> SearchProjectionFactoryExtensionIfSupportedStep<T, R, E> extension();

    @Incubating
    public SearchProjectionFactory<R, E> withRoot(String var1);

    @Incubating
    public String toAbsolutePath(String var1);
}

