/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.spi;

import java.util.function.Function;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortIndexScope;

public final class SearchSortDslContext<SC extends SearchSortIndexScope<?>, PDF extends SearchPredicateFactory> {
    private final SC scope;
    private final Function<SearchSortDslContext<SC, PDF>, SearchSortFactory> factoryProvider;
    private final SearchSortDslContext<?, ?> parent;
    private final SearchSort sort;
    private final PDF predicateFactory;
    private SearchSort compositeSort;

    public static <SC extends SearchSortIndexScope<?>, PDF extends SearchPredicateFactory> SearchSortDslContext<SC, PDF> root(SC scope, Function<SearchSortDslContext<SC, PDF>, SearchSortFactory> factoryProvider, PDF predicateFactory) {
        return new SearchSortDslContext<SC, PDF>(scope, factoryProvider, null, null, predicateFactory);
    }

    private SearchSortDslContext(SC scope, Function<SearchSortDslContext<SC, PDF>, SearchSortFactory> factoryProvider, SearchSortDslContext<?, ?> parent, SearchSort sort, PDF predicateFactory) {
        this.scope = scope;
        this.factoryProvider = factoryProvider;
        this.parent = parent;
        this.sort = sort;
        this.predicateFactory = predicateFactory;
    }

    public SC scope() {
        return this.scope;
    }

    public SearchSortFactory then() {
        return this.factoryProvider.apply(this);
    }

    public SearchSortDslContext<SC, PDF> rescope(SC newScope, PDF newPredicateFactory) {
        return new SearchSortDslContext<SC, PDF>(newScope, this.factoryProvider, this.parent, this.sort, newPredicateFactory);
    }

    public SearchSortDslContext<SC, PDF> append(SearchSort sort) {
        return new SearchSortDslContext<SC, PDF>(this.scope, this.factoryProvider, this, sort, this.predicateFactory);
    }

    public PDF predicateFactory() {
        return this.predicateFactory;
    }

    public SearchSort toSort() {
        if (this.compositeSort == null) {
            this.compositeSort = this.createCompositeSort();
        }
        return this.compositeSort;
    }

    private SearchSort createCompositeSort() {
        if (this.parent == null) {
            return this.scope.sortBuilders().composite().build();
        }
        if (this.parent.sort == null) {
            return this.sort;
        }
        CompositeSortBuilder builder = this.scope.sortBuilders().composite();
        this.collectSorts(builder);
        return builder.build();
    }

    private void collectSorts(CompositeSortBuilder builder) {
        if (this.sort == null) {
            return;
        }
        super.collectSorts(builder);
        builder.add(this.sort);
    }
}

