/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import jakarta.mail.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.mail.extension.MailExtension;
import org.jboss.as.mail.extension.MailServerDefinition;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionRemove;
import org.jboss.as.mail.extension.MailSessionWriteAttributeHandler;
import org.jboss.as.mail.extension.MailSubsystemModel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.common.function.ExceptionBiConsumer;

class MailSessionDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> SESSION_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.mail.session", (boolean)true, Session.class).build();
    private final List<AccessConstraintDefinition> accessConstraints;
    protected static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    protected static final SimpleAttributeDefinition FROM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("from", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowExpression(true)).setRequired(false)).build();
    protected static final SimpleAttributeDefinition DEBUG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("debug", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DEBUG, JNDI_NAME, FROM};

    MailSessionDefinition() {
        super(new SimpleResourceDefinition.Parameters(MailExtension.MAIL_SESSION_PATH, (ResourceDescriptionResolver)MailExtension.getResourceDescriptionResolver("mail-session")).setAddHandler((OperationStepHandler)new MailSessionAdd()).setRemoveHandler((OperationStepHandler)new MailSessionRemove()).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{SESSION_CAPABILITY}));
        ApplicationTypeConfig atc = new ApplicationTypeConfig("mail", "mail-session");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ExceptionBiConsumer remover = MailSessionRemove::removeSessionProviderService;
        ExceptionBiConsumer installer = MailSessionAdd::installSessionProviderService;
        for (AttributeDefinition attribute : ATTRIBUTES) {
            if (attribute.getName().equals(JNDI_NAME.getName())) continue;
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)new MailSessionWriteAttributeHandler(attribute, (ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException>)remover, (ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException>)installer));
        }
        registration.registerReadWriteAttribute((AttributeDefinition)JNDI_NAME, null, (OperationStepHandler)new MailSessionWriteAttributeHandler((AttributeDefinition)JNDI_NAME, (ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException>)((ExceptionBiConsumer)MailSessionRemove::removeBinderService), (ExceptionBiConsumer<OperationContext, ModelNode, OperationFailedException>)((ExceptionBiConsumer)MailSessionAdd::installBinderService)));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return List.of(new MailServerDefinition(MailSubsystemModel.IMAP_SERVER_PATH, MailServerDefinition.ATTRIBUTES), new MailServerDefinition(MailSubsystemModel.POP3_SERVER_PATH, MailServerDefinition.ATTRIBUTES), new MailServerDefinition(MailSubsystemModel.SMTP_SERVER_PATH, MailServerDefinition.ATTRIBUTES), new MailServerDefinition(MailSubsystemModel.CUSTOM_SERVER_PATH, MailServerDefinition.ATTRIBUTES_CUSTOM));
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

