/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import org.hibernate.validator.constraints.UUID;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

public class UUIDValidator
implements ConstraintValidator<UUID, CharSequence> {
    private static final int[] GROUP_LENGTHS = new int[]{8, 4, 4, 4, 12};
    private boolean allowEmpty;
    private boolean allowNil;
    private int[] version;
    private int[] variant;
    private UUID.LetterCase letterCase;

    public void initialize(UUID constraintAnnotation) {
        this.allowEmpty = constraintAnnotation.allowEmpty();
        this.allowNil = constraintAnnotation.allowNil();
        this.version = UUIDValidator.checkAndSortMultiOptionParameter(constraintAnnotation.version(), "version", 1, 15);
        this.variant = UUIDValidator.checkAndSortMultiOptionParameter(constraintAnnotation.variant(), "variant", 0, 2);
        this.letterCase = constraintAnnotation.letterCase();
        Contracts.assertNotNull((Object)this.letterCase, Messages.MESSAGES.parameterMustNotBeNull("letterCase"));
    }

    private static int[] checkAndSortMultiOptionParameter(int[] values, String parameterName, int minimum, int maximum) {
        Contracts.assertNotNull(values, Messages.MESSAGES.parameterMustNotBeNull(parameterName));
        Contracts.assertNotEmpty(values, Messages.MESSAGES.parameterMustNotBeEmpty(parameterName));
        for (int value : values) {
            Contracts.assertTrue(value >= minimum, Messages.MESSAGES.parameterShouldBeGreaterThanOrEqualTo(parameterName, minimum));
            Contracts.assertTrue(value <= maximum, Messages.MESSAGES.parameterShouldBeLessThanOrEqualTo(parameterName, maximum));
        }
        Arrays.sort(values);
        return values;
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        int valueLength = value.length();
        if (valueLength == 0) {
            return this.allowEmpty;
        }
        if (valueLength != 36) {
            return false;
        }
        int groupIndex = 0;
        int groupLength = 0;
        int checksum = 0;
        int version = -1;
        int variant = -1;
        for (int charIndex = 0; charIndex < valueLength; ++charIndex) {
            char ch = value.charAt(charIndex);
            if (ch == '-') {
                ++groupIndex;
                groupLength = 0;
                continue;
            }
            if (++groupLength > GROUP_LENGTHS[groupIndex]) {
                return false;
            }
            int numericValue = Character.digit(ch, 16);
            if (numericValue == -1) {
                return false;
            }
            if (numericValue > 9 && !this.hasCorrectLetterCase(ch)) {
                return false;
            }
            checksum += numericValue;
            version = UUIDValidator.extractVersion(version, charIndex, numericValue);
            variant = UUIDValidator.extractVariant(variant, charIndex, numericValue);
        }
        if (checksum == 0) {
            return this.allowNil;
        }
        if (Arrays.binarySearch(this.version, version) == -1) {
            return false;
        }
        return Arrays.binarySearch(this.variant, variant) != -1;
    }

    private boolean hasCorrectLetterCase(char ch) {
        if (this.letterCase == null) {
            return true;
        }
        if (this.letterCase == UUID.LetterCase.LOWER_CASE && !Character.isLowerCase(ch)) {
            return false;
        }
        return this.letterCase != UUID.LetterCase.UPPER_CASE || Character.isUpperCase(ch);
    }

    private static int extractVersion(int version, int index, int value) {
        if (index == 14) {
            return value;
        }
        return version;
    }

    private static int extractVariant(int variant, int index, int value) {
        if (index == 19) {
            if (value >> 3 == 0) {
                return 0;
            }
            if (value >> 2 == 2) {
                return 1;
            }
            if (value >> 1 == 6) {
                return 2;
            }
        }
        return variant;
    }
}

