/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.valueextraction;

import jakarta.validation.valueextraction.ValueExtractor;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ReadOnlyMapProperty;
import org.hibernate.validator.internal.IgnoreForbiddenApisErrors;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;

@IgnoreForbiddenApisErrors(reason="Usage of JavaFX classes")
class ReadOnlyMapPropertyKeyExtractor
implements ValueExtractor<ReadOnlyMapProperty<?, ?>> {
    static final ValueExtractorDescriptor DESCRIPTOR = new ValueExtractorDescriptor(new ReadOnlyMapPropertyKeyExtractor(), ReadOnlyMapProperty.class, ReadOnlyMapProperty.class.getTypeParameters()[0], false, Optional.empty());

    private ReadOnlyMapPropertyKeyExtractor() {
    }

    public void extractValues(ReadOnlyMapProperty<?, ?> originalValue, ValueExtractor.ValueReceiver receiver) {
        for (Map.Entry entry : originalValue.entrySet()) {
            receiver.keyedValue("<map key>", entry.getKey(), entry.getKey());
        }
    }
}

