/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jdr.JdrReportRequestHandler;
import org.jboss.as.jdr.JdrReportSubsystemDefinition;
import org.jboss.as.jdr.JdrReportSubsystemSchema;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JdrReportExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jdr";
    private static final ModelVersion CURRENT_MODEL_VERSION = ModelVersion.create((int)2, (int)0, (int)0);
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jdr");
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("jdr", JdrReportExtension.class);
    static final SensitivityClassification JDR_SENSITIVITY = new SensitivityClassification("jdr", "jdr", false, false, true);
    static final SensitiveTargetAccessConstraintDefinition JDR_SENSITIVITY_DEF = new SensitiveTargetAccessConstraintDefinition(JDR_SENSITIVITY);
    private final PersistentResourceXMLDescription currentDescription = JdrReportSubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        ManagementResourceRegistration root = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new JdrReportSubsystemDefinition());
        root.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (context.isRuntimeOnlyRegistrationValid()) {
            root.registerOperationHandler((OperationDefinition)JdrReportRequestHandler.DEFINITION, (OperationStepHandler)JdrReportRequestHandler.INSTANCE);
        }
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (JdrReportSubsystemSchema schema : EnumSet.allOf(JdrReportSubsystemSchema.class)) {
            JdrReportSubsystemSchema reader = schema == JdrReportSubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }
}

