/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.impl.ShardingStrategyInitializationContextImpl;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.DirectoryReaderCollector;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.schema.management.impl.SchemaManagementIndexManagerContext;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.resources.spi.SavedState;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;

class ShardHolder
implements ReadIndexManagerContext,
WorkExecutionIndexManagerContext,
SchemaManagementIndexManagerContext {
    private static final SavedState.Key<Map<String, SavedState>> SHARDS_KEY = SavedState.key((String)"shards");
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private BeanHolder<? extends ShardingStrategy> shardingStrategyHolder;
    private final Map<String, Shard> shards = new LinkedHashMap<String, Shard>();
    private final List<LuceneParallelWorkOrchestrator> managementOrchestrators = new ArrayList<LuceneParallelWorkOrchestrator>();

    ShardHolder(IndexManagerBackendContext backendContext, LuceneIndexModel model) {
        this.backendContext = backendContext;
        this.model = model;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexName=" + this.model.hibernateSearchName() + "]";
    }

    public SavedState saveForRestart() {
        HashMap<String, SavedState> states = new HashMap<String, SavedState>();
        for (Map.Entry<String, Shard> shard : this.shards.entrySet()) {
            states.put(shard.getKey(), shard.getValue().saveForRestart());
        }
        return SavedState.builder().put(SHARDS_KEY, states).build();
    }

    private ConfigurationPropertySource toShardPropertySource(ConfigurationPropertySource indexPropertySource, String shardIdOrNull) {
        return shardIdOrNull != null ? indexPropertySource.withMask("shards").withMask(shardIdOrNull).withFallback(indexPropertySource) : indexPropertySource;
    }

    void preStart(IndexManagerStartContext startContext, SavedState savedState) {
        ConfigurationPropertySource indexPropertySource = startContext.configurationPropertySource();
        try {
            ShardingStrategyInitializationContextImpl initializationContext = new ShardingStrategyInitializationContextImpl(this.backendContext, this.model, startContext, indexPropertySource);
            Map states = savedState.get(SHARDS_KEY).orElse(Collections.emptyMap());
            this.shardingStrategyHolder = initializationContext.create(this.shards);
            for (Map.Entry<String, Shard> entry : this.shards.entrySet()) {
                String shardId = entry.getKey();
                Shard shard = entry.getValue();
                ConfigurationPropertySource shardPropertySource = this.toShardPropertySource(indexPropertySource, shardId);
                try {
                    shard.preStart(shardPropertySource, startContext.beanResolver(), states.getOrDefault(entry.getKey(), SavedState.empty()));
                }
                catch (RuntimeException e) {
                    startContext.failureCollector().withContext(shardId == null ? null : EventContexts.fromShardId((String)shardId)).add((Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            throw e;
        }
    }

    void start(IndexManagerStartContext startContext) {
        ConfigurationPropertySource indexPropertySource = startContext.configurationPropertySource();
        try {
            for (Map.Entry<String, Shard> entry : this.shards.entrySet()) {
                String shardId = entry.getKey();
                Shard shard = entry.getValue();
                ConfigurationPropertySource shardPropertySource = this.toShardPropertySource(indexPropertySource, shardId);
                try {
                    shard.start(shardPropertySource);
                    this.managementOrchestrators.add(shard.managementOrchestrator());
                }
                catch (RuntimeException e) {
                    startContext.failureCollector().withContext(shardId == null ? null : EventContexts.fromShardId((String)shardId)).add((Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(Shard::stop, this.shards.values());
            this.managementOrchestrators.clear();
            throw e;
        }
    }

    CompletableFuture<?> preStop() {
        CompletableFuture[] futures = new CompletableFuture[this.shards.size()];
        int i = 0;
        for (Shard shard : this.shards.values()) {
            futures[i] = shard.preStop();
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }

    void stop() {
        try (Closer closer = new Closer();){
            closer.pushAll(Shard::stop, this.shards.values());
            this.shards.clear();
            this.managementOrchestrators.clear();
        }
    }

    @Override
    public void openIndexReaders(Set<String> routingKeys, DirectoryReaderCollector readerCollector) throws IOException {
        String mappedTypeName = this.model.mappedTypeName();
        Collection<Shard> enabledShards = this.toShards(routingKeys);
        for (Shard shard : enabledShards) {
            readerCollector.collect(mappedTypeName, shard.openReader());
        }
    }

    @Override
    public String mappedTypeName() {
        return this.model.mappedTypeName();
    }

    @Override
    public LuceneSerialWorkOrchestrator indexingOrchestrator(String documentId, String routingKey) {
        return this.toShard(documentId, routingKey).indexingOrchestrator();
    }

    @Override
    public List<LuceneParallelWorkOrchestrator> managementOrchestrators(Set<String> routingKeys) {
        Collection<Shard> enabledShards = this.toShards(routingKeys);
        ArrayList<LuceneParallelWorkOrchestrator> orchestrators = new ArrayList<LuceneParallelWorkOrchestrator>();
        for (Shard shard : enabledShards) {
            orchestrators.add(shard.managementOrchestrator());
        }
        return orchestrators;
    }

    @Override
    public List<LuceneParallelWorkOrchestrator> allManagementOrchestrators() {
        return this.managementOrchestrators;
    }

    public List<Shard> shardsForTests() {
        return new ArrayList<Shard>(this.shards.values());
    }

    private Collection<Shard> toShards(Set<String> routingKeys) {
        if (this.shardingStrategyHolder == null || routingKeys.isEmpty()) {
            return this.shards.values();
        }
        Set<String> shardIdentifiers = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifiers(routingKeys);
        HashSet<Shard> enabledShards = new HashSet<Shard>();
        for (String shardId : shardIdentifiers) {
            enabledShards.add(this.shards.get(shardId));
        }
        return enabledShards;
    }

    private Shard toShard(String documentId, String routingKey) {
        if (this.shardingStrategyHolder == null) {
            return this.shards.values().iterator().next();
        }
        String shardId = ((ShardingStrategy)this.shardingStrategyHolder.get()).toShardIdentifier(documentId, routingKey);
        return this.shards.get(shardId);
    }
}

