/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.IntervalPredicate;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.be.PredicateNode;
import org.infinispan.objectfilter.impl.util.IntervalTree;

public final class Predicates<AttributeDomain extends Comparable<AttributeDomain>, AttributeId extends Comparable<AttributeId>> {
    private final boolean useIntervals;
    private IntervalTree<AttributeDomain, Subscriptions> orderedPredicates;
    private List<Subscriptions> unorderedPredicates;

    Predicates(boolean useIntervals) {
        this.useIntervals = useIntervals;
    }

    public void notifyMatchingSubscribers(MatcherEvalContext<?, ?, ?> ctx, Object attributeValue) {
        if (this.orderedPredicates != null && attributeValue instanceof Comparable) {
            this.orderedPredicates.stab((Comparable)attributeValue, node -> {
                Subscriptions subscriptions = (Subscriptions)node.value;
                if (subscriptions.isActive(ctx)) {
                    for (Subscription s : subscriptions.subscriptions) {
                        s.handleValue(ctx, true);
                    }
                }
            });
        }
        if (this.unorderedPredicates != null) {
            for (int k = this.unorderedPredicates.size() - 1; k >= 0; --k) {
                Subscriptions subscriptions = this.unorderedPredicates.get(k);
                if (!subscriptions.isActive(ctx)) continue;
                boolean isMatching = subscriptions.predicate.match(attributeValue);
                List<Subscription> s = subscriptions.subscriptions;
                for (int i = s.size() - 1; i >= 0; --i) {
                    s.get(i).handleValue(ctx, isMatching);
                }
            }
        }
    }

    public Subscription<AttributeId> addPredicateSubscription(PredicateNode predicateNode, FilterSubscriptionImpl filterSubscription) {
        Subscriptions subscriptions;
        Predicate<?> predicate = predicateNode.getPredicate();
        if (this.useIntervals && predicate instanceof IntervalPredicate) {
            if (this.orderedPredicates == null) {
                this.orderedPredicates = new IntervalTree();
            }
            IntervalTree.Node<AttributeDomain, Subscriptions> n = this.orderedPredicates.add(((IntervalPredicate)predicate).getInterval());
            if (n.value == null) {
                subscriptions = new Subscriptions(predicate);
                n.value = subscriptions;
            } else {
                subscriptions = (Subscriptions)n.value;
            }
        } else {
            subscriptions = null;
            if (this.unorderedPredicates == null) {
                this.unorderedPredicates = new ArrayList<Subscriptions>();
            } else {
                for (int i = 0; i < this.unorderedPredicates.size(); ++i) {
                    Subscriptions s = this.unorderedPredicates.get(i);
                    if (!s.predicate.equals(predicate)) continue;
                    subscriptions = s;
                    break;
                }
            }
            if (subscriptions == null) {
                subscriptions = new Subscriptions(predicate);
                this.unorderedPredicates.add(subscriptions);
            }
        }
        Subscription subscription = new Subscription(predicateNode, filterSubscription);
        subscriptions.add(subscription);
        return subscription;
    }

    public void removePredicateSubscription(Subscription subscription) {
        Predicate<?> predicate = subscription.predicateNode.getPredicate();
        if (this.useIntervals && predicate instanceof IntervalPredicate) {
            if (this.orderedPredicates != null) {
                IntervalTree.Node<AttributeDomain, Subscriptions> n = this.orderedPredicates.findNode(((IntervalPredicate)predicate).getInterval());
                if (n != null) {
                    ((Subscriptions)n.value).remove(subscription);
                    if (((Subscriptions)n.value).isEmpty()) {
                        this.orderedPredicates.remove(n);
                    }
                } else {
                    Predicates.throwIllegalStateException();
                }
            } else {
                Predicates.throwIllegalStateException();
            }
        } else if (this.unorderedPredicates != null) {
            for (int i = 0; i < this.unorderedPredicates.size(); ++i) {
                Subscriptions subscriptions = this.unorderedPredicates.get(i);
                if (!subscriptions.predicate.equals(predicate)) continue;
                subscriptions.remove(subscription);
                if (subscriptions.isEmpty()) {
                    this.unorderedPredicates.remove(i);
                }
                break;
            }
        } else {
            Predicates.throwIllegalStateException();
        }
    }

    public boolean isEmpty() {
        return !(this.unorderedPredicates != null && !this.unorderedPredicates.isEmpty() || this.orderedPredicates != null && !this.orderedPredicates.isEmpty());
    }

    private static void throwIllegalStateException() throws IllegalStateException {
        throw new IllegalStateException("Reached an invalid state");
    }

    private static class Subscriptions {
        private final Predicate predicate;
        private final List<Subscription> subscriptions = new ArrayList<Subscription>();

        private Subscriptions(Predicate predicate) {
            this.predicate = predicate;
        }

        void add(Subscription subscription) {
            this.subscriptions.add(subscription);
        }

        void remove(Subscription subscription) {
            this.subscriptions.remove(subscription);
        }

        boolean isEmpty() {
            return this.subscriptions.isEmpty();
        }

        boolean isActive(MatcherEvalContext<?, ?, ?> ctx) {
            return !this.predicate.isRepeated() || ctx.getSuspendedSubscriptionsCounter(this.predicate) < this.subscriptions.size();
        }
    }

    public static final class Subscription<AttributeId extends Comparable<AttributeId>> {
        private final PredicateNode<AttributeId> predicateNode;
        private final FilterSubscriptionImpl filterSubscription;

        private Subscription(PredicateNode<AttributeId> predicateNode, FilterSubscriptionImpl filterSubscription) {
            this.predicateNode = predicateNode;
            this.filterSubscription = filterSubscription;
        }

        private void handleValue(MatcherEvalContext<?, ?, ?> ctx, boolean isMatching) {
            FilterEvalContext filterEvalContext = ctx.getFilterEvalContext(this.filterSubscription);
            if (!this.predicateNode.isEvaluationComplete(filterEvalContext)) {
                if (this.predicateNode.isNegated()) {
                    boolean bl = isMatching = !isMatching;
                }
                if (isMatching || !this.predicateNode.getPredicate().isRepeated()) {
                    this.predicateNode.handleChildValue(null, isMatching, filterEvalContext);
                }
            }
        }

        public PredicateNode<AttributeId> getPredicateNode() {
            return this.predicateNode;
        }
    }
}

