/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.AbstractFederatingContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.NamingOperation;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.RetryContext;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteClientTransport;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.store.RelativeFederatingContext;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.naming.client.util.NamingUtils;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class RemoteContext
extends AbstractFederatingContext {
    private static final int MAX_NOT_FOUND_RETRY = 8;
    private final RemoteNamingProvider provider;
    private final String scheme;

    RemoteContext(RemoteNamingProvider provider, String scheme, Hashtable<String, Object> env) throws CommunicationException {
        super(FastHashtable.of(env));
        this.provider = provider;
        this.scheme = scheme;
    }

    RemoteClientTransport getRemoteTransport(ConnectionPeerIdentity peerIdentity) throws NamingException {
        Endpoint endpoint = this.provider.getEndpoint();
        if (endpoint == null) {
            throw Messages.log.noRemotingEndpoint();
        }
        try {
            Connection connection = peerIdentity.getConnection();
            IoFuture future = RemoteClientTransport.SERVICE_HANDLE.getClientService(connection, OptionMap.EMPTY);
            try {
                return (RemoteClientTransport)future.getInterruptibly();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel();
                throw Messages.log.operationInterrupted();
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof NamingException) {
                throw (NamingException)e.getCause();
            }
            throw Messages.log.connectFailed(e);
        }
    }

    private boolean canRetry(ProviderEnvironment environment) {
        return environment.getProviderUris().size() > 1;
    }

    private <T, R> R performWithRetry(NamingOperation<T, R> function, ProviderEnvironment environment, RetryContext context, Name name, T param) throws NamingException {
        if (context == null) {
            return this.provider.performExceptionAction(function, context, name, param);
        }
        int notFound = 0;
        while (true) {
            URI location;
            try {
                R result = this.provider.performExceptionAction(function, context, name, param);
                environment.dropFromBlocklist(context.currentDestination());
                return result;
            }
            catch (NameNotFoundException e) {
                if (notFound++ > 8) {
                    Messages.log.tracef("Maximum name not found attempts exceeded,", new Object[0]);
                    throw e;
                }
                location = context.currentDestination();
                Messages.log.tracef("Provider (%s) did not have name \"%s\" (or a portion), retrying other nodes", location, name);
                context.addExplicitFailure(e);
                context.addTransientFail(location);
                continue;
            }
            catch (ExhaustedDestinationsException e) {
                throw e;
            }
            catch (CommunicationException t) {
                location = context.currentDestination();
                Messages.log.tracef(t, "Communication error while contacting %s", location);
                this.updateBlocklist(environment, context, t);
                context.addFailure(RemoteContext.injectDestination(t, location));
                continue;
            }
            catch (NamingException e) {
                environment.dropFromBlocklist(context.currentDestination());
                throw e;
            }
            catch (Throwable t) {
                location = context.currentDestination();
                Messages.log.tracef(t, "Unexpected throwable while contacting %s", location);
                context.addTransientFail(location);
                context.addFailure(RemoteContext.injectDestination(t, location));
                continue;
            }
            break;
        }
    }

    private static Throwable injectDestination(Throwable t, URI destination) {
        StackTraceElement[] stackTrace = new StackTraceElement[5];
        System.arraycopy(t.getStackTrace(), 0, stackTrace, 1, 4);
        stackTrace[0] = new StackTraceElement("", "..use of destination...", destination.toString(), -1);
        t.setStackTrace(stackTrace);
        IdentityHashMap<Throwable, Throwable> encountered = new IdentityHashMap<Throwable, Throwable>(3);
        encountered.put(t, t);
        for (Throwable cause = t.getCause(); cause != null && encountered.get(cause) == null; cause = cause.getCause()) {
            encountered.put(cause, cause);
            cause.setStackTrace(Arrays.copyOfRange(cause.getStackTrace(), 0, 5));
        }
        return t;
    }

    private void updateBlocklist(ProviderEnvironment environment, RetryContext context, Throwable t) {
        URI location = context.currentDestination();
        Messages.log.tracef(t, "Provider (%s) failed, blocklisting and retrying", location);
        environment.updateBlocklist(location);
    }

    Name getRealName(Name name) throws InvalidNameException {
        if (this.scheme == null) {
            return name;
        }
        if (name.isEmpty()) {
            return new CompositeName(this.scheme + ":");
        }
        String part0 = name.get(0);
        Name clone = (Name)name.clone();
        clone.remove(0);
        clone.add(0, this.scheme + ":" + part0);
        return clone;
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        if (realName.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            return this.getRemoteTransport(peerIdentity).lookup(this, name_, peerIdentity, false);
        }, environment, context, realName, null);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        if (realName.isEmpty()) {
            return new RemoteContext(this.provider, this.scheme, this.getEnvironment());
        }
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            return this.getRemoteTransport(peerIdentity).lookup(this, name_, peerIdentity, true);
        }, environment, context, realName, null);
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((context_, name_, obj_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            this.getRemoteTransport(peerIdentity).bind(name_, obj_, peerIdentity, false);
            return null;
        }, environment, context, realName, obj);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((context_, name_, obj_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            this.getRemoteTransport(peerIdentity).bind(name_, obj_, peerIdentity, true);
            return null;
        }, environment, context, realName, obj);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            this.getRemoteTransport(peerIdentity).unbind(name_, peerIdentity);
            return null;
        }, environment, context, realName, null);
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        Name realOldName = this.getRealName(oldName);
        Name realNewName = this.getRealName(newName);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((context_, oldName_, newName_) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            this.getRemoteTransport(peerIdentity).rename(oldName_, (Name)newName_, peerIdentity);
            return null;
        }, environment, context, realOldName, realNewName);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            return this.getRemoteTransport(peerIdentity).list(name_, peerIdentity);
        }, environment, context, realName, null);
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            return this.getRemoteTransport(peerIdentity).listBindings(name_, this, peerIdentity);
        }, environment, context, realName, null);
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            this.getRemoteTransport(peerIdentity).destroySubcontext(name_, peerIdentity);
            return null;
        }, environment, context, realName, null);
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        Name realName = this.getRealName(name);
        ProviderEnvironment environment = this.provider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((context_, name_, ignored) -> {
            ConnectionPeerIdentity peerIdentity = this.provider.getPeerIdentityForNamingUsingRetry(context_);
            CompositeName compositeName = NamingUtils.toCompositeName(name_);
            this.getRemoteTransport(peerIdentity).createSubcontext(compositeName, peerIdentity);
            return new RelativeFederatingContext((FastHashtable<String, Object>)this.getEnvironment(), this, compositeName);
        }, environment, context, realName, null);
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }
}

