/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.naming.subsystem.NamingBindingResourceDefinition;
import org.jboss.as.naming.subsystem.NamingExtension;
import org.jboss.as.naming.subsystem.NamingSubsystemNamespace;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLAttribute;
import org.jboss.as.naming.subsystem.NamingSubsystemXMLElement;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class NamingSubsystem12Parser
implements XMLElementReader<List<ModelNode>> {
    NamingSubsystem12Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        operations.add(Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{NamingExtension.SUBSYSTEM_PATH})));
        EnumSet<NamingSubsystemXMLElement> encountered = EnumSet.noneOf(NamingSubsystemXMLElement.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case NAMING_1_2: {
                    NamingSubsystemXMLElement element = NamingSubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case BINDINGS: {
                            this.parseBindings(reader, operations);
                            continue block7;
                        }
                        case REMOTE_NAMING: {
                            this.parseRemoteNaming(reader, operations);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteNaming(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode remoteNamingAdd = new ModelNode();
        remoteNamingAdd.get("operation").set("add");
        remoteNamingAdd.get("address").add("subsystem", "naming");
        remoteNamingAdd.get("address").add("service", "remote-naming");
        operations.add(remoteNamingAdd);
    }

    private void parseBindings(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (NamingSubsystemXMLElement.forName(reader.getLocalName())) {
                case SIMPLE: {
                    this.parseSimpleBinding(reader, operations);
                    continue block5;
                }
                case OBJECT_FACTORY: {
                    this.parseObjectFactoryBinding(reader, operations);
                    continue block5;
                }
                case LOOKUP: {
                    this.parseLookupBinding(reader, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSimpleBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String bindingValue = null;
        String type = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.VALUE);
        block5: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case VALUE: {
                    bindingValue = NamingBindingResourceDefinition.VALUE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                case TYPE: {
                    type = NamingBindingResourceDefinition.TYPE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("simple");
        bindingAdd.get("value").set(bindingValue);
        if (type != null) {
            bindingAdd.get("type").set(type);
        }
        operations.add(bindingAdd);
    }

    private void parseObjectFactoryBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String module = null;
        String factory = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.MODULE, NamingSubsystemXMLAttribute.CLASS);
        block5: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block5;
                }
                case MODULE: {
                    module = NamingBindingResourceDefinition.MODULE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                case CLASS: {
                    factory = NamingBindingResourceDefinition.CLASS.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("object-factory");
        bindingAdd.get("module").set(module);
        bindingAdd.get("class").set(factory);
        operations.add(bindingAdd);
    }

    private void parseLookupBinding(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String name = null;
        String lookup = null;
        EnumSet<NamingSubsystemXMLAttribute> required = EnumSet.of(NamingSubsystemXMLAttribute.NAME, NamingSubsystemXMLAttribute.LOOKUP);
        block4: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            NamingSubsystemXMLAttribute attribute = NamingSubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value.trim();
                    continue block4;
                }
                case LOOKUP: {
                    lookup = NamingBindingResourceDefinition.LOOKUP.parse(value, (XMLStreamReader)reader).asString();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "naming");
        address.add("binding", name);
        ModelNode bindingAdd = new ModelNode();
        bindingAdd.get("operation").set("add");
        bindingAdd.get("address").set(address);
        bindingAdd.get("binding-type").set("lookup");
        bindingAdd.get("lookup").set(lookup);
        operations.add(bindingAdd);
    }
}

